/*
 * Decompiled with CFR 0.152.
 */
package ca.eandb.jdcp.worker;

import ca.eandb.jdcp.remote.TaskService;
import ca.eandb.util.classloader.ClassLoaderStrategy;
import java.nio.ByteBuffer;
import java.rmi.RemoteException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.log4j.Logger;

public abstract class CachingJobServiceClassLoaderStrategy
implements ClassLoaderStrategy {
    private static final Logger logger = Logger.getLogger(CachingJobServiceClassLoaderStrategy.class);
    private final TaskService service;
    private final UUID jobId;
    private Map<String, byte[]> digestLookup = Collections.synchronizedMap(new HashMap());
    private Map<String, String> pendingDigest = new HashMap<String, String>();
    private Map<String, String> pendingDef = new HashMap<String, String>();

    protected CachingJobServiceClassLoaderStrategy(TaskService service, UUID jobId) {
        this.service = service;
        this.jobId = jobId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final byte[] getClassDigest(String name) {
        byte[] digest;
        block8: {
            digest = this.digestLookup.get(name);
            if (digest == null) {
                try {
                    if (this.beginLookup(this.pendingDigest, name)) {
                        try {
                            digest = this.service.getClassDigest(name, this.jobId);
                            this.digestLookup.put(name, digest);
                            break block8;
                        }
                        finally {
                            this.endLookup(this.pendingDigest, name);
                        }
                    }
                    digest = this.digestLookup.get(name);
                }
                catch (SecurityException e) {
                    logger.error((Object)"Could not get class digest", (Throwable)e);
                }
                catch (RemoteException e) {
                    logger.error((Object)"Could not get class digest", (Throwable)e);
                }
            }
        }
        return digest;
    }

    private synchronized boolean beginLookup(Map<String, String> pending, String name) {
        String canonical = pending.get(name);
        if (canonical != null) {
            do {
                try {
                    canonical.wait();
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            } while (pending.containsKey(name));
        }
        return canonical == null;
    }

    private synchronized void endLookup(Map<String, String> pending, String name) {
        String canonical = pending.remove(name);
        if (canonical != null) {
            canonical.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public final ByteBuffer getClassDefinition(String name) {
        try {
            digest = this.getClassDigest(name);
            def = this.cacheLookup(name, digest);
            if (def == null) {
                if (this.beginLookup(this.pendingDef, name)) {
                    try {
                        def = this.service.getClassDefinition(name, this.jobId);
                        if (def == null) ** GOTO lbl15
                        this.cacheStore(name, digest, def);
                    }
                    finally {
                        this.endLookup(this.pendingDef, name);
                    }
                } else {
                    def = this.cacheLookup(name, digest);
                }
            }
lbl15:
            // 5 sources

            if (def != null) {
                return ByteBuffer.wrap(def);
            }
        }
        catch (RemoteException e) {
            CachingJobServiceClassLoaderStrategy.logger.error((Object)"Could not get class definition", (Throwable)e);
        }
        return null;
    }

    protected abstract byte[] cacheLookup(String var1, byte[] var2);

    protected abstract void cacheStore(String var1, byte[] var2, byte[] var3);
}

