/*
 * Decompiled with CFR 0.152.
 */
package ca.eandb.jdcp.remote;

import ca.eandb.jdcp.remote.JobStatus;
import ca.eandb.util.progress.ProgressMonitor;
import ca.eandb.util.progress.ProgressMonitorFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public final class JobStatusMonitor {
    private final ProgressMonitorFactory factory;
    private final Map<UUID, JobMonitor> monitors = new HashMap<UUID, JobMonitor>();

    public JobStatusMonitor(ProgressMonitorFactory factory) {
        this.factory = factory;
    }

    private synchronized JobMonitor getJobMonitor(JobStatus status) {
        UUID jobId = status.getJobId();
        JobMonitor monitor = this.monitors.get(jobId);
        if (monitor == null) {
            monitor = new JobMonitor(this.factory.createProgressMonitor(status.getDescription()));
            this.monitors.put(jobId, monitor);
        }
        return monitor;
    }

    public void updateStatus(JobStatus newStatus) {
        JobMonitor monitor = this.getJobMonitor(newStatus);
        monitor.updateStatus(newStatus);
    }

    private static class JobMonitor {
        private final ProgressMonitor monitor;
        private JobStatus status = null;

        public JobMonitor(ProgressMonitor monitor) {
            this.monitor = monitor;
        }

        public synchronized void updateStatus(JobStatus newStatus) {
            assert (this.status == null || newStatus.getJobId().equals(this.status.getJobId()));
            if (newStatus.isProgressIndeterminant()) {
                this.monitor.notifyIndeterminantProgress();
            } else if (this.status == null || newStatus.getProgress() != this.status.getProgress()) {
                this.monitor.notifyProgress(newStatus.getProgress());
            }
            if (this.status == null || !newStatus.getStatus().equals(this.status.getStatus())) {
                this.monitor.notifyStatusChanged(newStatus.getStatus());
            }
            if (newStatus.isComplete() && (this.status == null || !this.status.isComplete())) {
                this.monitor.notifyComplete();
            }
            if (newStatus.isCancelled() && (this.status == null || !this.status.isCancelled())) {
                this.monitor.notifyCancelled();
            }
            this.status = newStatus;
        }
    }
}

