/*
 * Decompiled with CFR 0.152.
 */
package ca.eandb.jdcp.remote;

import ca.eandb.jdcp.remote.JobState;
import java.io.Serializable;
import java.util.Random;
import java.util.UUID;

public final class JobStatus
implements Serializable {
    private static final long serialVersionUID = 2060688367370302207L;
    private final UUID jobId;
    private final String description;
    private final JobState state;
    private final double progress;
    private final String status;
    private final long eventId;
    private static long nextEventId = -Math.abs(new Random().nextLong());

    private static synchronized long getNextEventId() {
        return nextEventId++;
    }

    private JobStatus(UUID jobId, String description, JobState state, double progress, String status, long eventId) {
        this.jobId = jobId;
        this.description = description;
        this.state = state;
        this.progress = progress;
        this.status = status;
        this.eventId = eventId;
    }

    public JobStatus(UUID jobId, String description, JobState state, double progress, String status) {
        this(jobId, description, state, progress, status, Long.MIN_VALUE);
    }

    public JobStatus(UUID jobId, String description, JobState state, String status) {
        this(jobId, description, state, Double.NaN, status);
    }

    public JobStatus withProgress(double newProgress) {
        return new JobStatus(this.jobId, this.description, this.state, newProgress, this.status, this.eventId);
    }

    public JobStatus withStatus(String newStatus) {
        return new JobStatus(this.jobId, this.description, this.state, this.progress, newStatus, this.eventId);
    }

    public JobStatus asComplete() {
        return new JobStatus(this.jobId, this.description, JobState.COMPLETE, 1.0, this.status, this.eventId);
    }

    public JobStatus asCancelled() {
        return new JobStatus(this.jobId, this.description, JobState.CANCELLED, this.progress, this.status, this.eventId);
    }

    public JobStatus withIndeterminantProgress() {
        return new JobStatus(this.jobId, this.description, this.state, Double.NaN, this.status, this.eventId);
    }

    public JobStatus withNewEventId() {
        return new JobStatus(this.jobId, this.description, this.state, Double.NaN, this.status, JobStatus.getNextEventId());
    }

    public UUID getJobId() {
        return this.jobId;
    }

    public String getDescription() {
        return this.description;
    }

    public JobState getState() {
        return this.state;
    }

    public boolean isComplete() {
        return this.state == JobState.COMPLETE;
    }

    public boolean isCancelled() {
        return this.state == JobState.CANCELLED;
    }

    public double getProgress() {
        return this.progress;
    }

    public boolean isProgressIndeterminant() {
        return Double.isNaN(this.progress);
    }

    public String getStatus() {
        return this.status;
    }

    public long getEventId() {
        return this.eventId;
    }
}

