/*
 * Decompiled with CFR 0.152.
 */
package ca.eandb.jdcp.job;

import ca.eandb.jdcp.job.HostService;
import ca.eandb.jdcp.job.ParallelizableJob;
import ca.eandb.jdcp.job.TaskWorker;
import ca.eandb.util.progress.ProgressMonitor;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Random;

public class TaskRandomizedJob
implements ParallelizableJob {
    private static final long serialVersionUID = -6185355912678518969L;
    private final ParallelizableJob inner;
    private final ArrayList<Object> tasks = new ArrayList();
    private final Random random = new Random();

    public TaskRandomizedJob(ParallelizableJob inner) {
        this.inner = inner;
    }

    @Override
    public Object getNextTask() throws Exception {
        Object task;
        while ((task = this.inner.getNextTask()) != null) {
            int pos = this.random.nextInt(this.tasks.size() + 1);
            if (pos == this.tasks.size()) {
                this.tasks.add(task);
                continue;
            }
            this.tasks.add(this.tasks.get(pos));
            this.tasks.set(pos, task);
        }
        return this.tasks.isEmpty() ? null : this.tasks.remove(this.tasks.size() - 1);
    }

    @Override
    public boolean isComplete() throws Exception {
        return this.inner.isComplete();
    }

    @Override
    public void submitTaskResults(Object task, Object results, ProgressMonitor monitor) throws Exception {
        this.inner.submitTaskResults(task, results, monitor);
    }

    @Override
    public void finish() throws Exception {
        this.inner.finish();
    }

    @Override
    public void initialize() throws Exception {
        this.inner.initialize();
    }

    @Override
    public void restoreState(ObjectInput input) throws Exception {
        this.inner.restoreState(input);
    }

    @Override
    public void saveState(ObjectOutput output) throws Exception {
        this.inner.saveState(output);
    }

    @Override
    public void setHostService(HostService host) {
        this.inner.setHostService(host);
    }

    @Override
    public TaskWorker worker() throws Exception {
        return this.inner.worker();
    }
}

