/*
 * Decompiled with CFR 0.152.
 */
package ca.eandb.jdcp.job;

import ca.eandb.jdcp.job.HostService;
import ca.eandb.jdcp.job.JobExecutionException;
import ca.eandb.jdcp.job.JobExecutionWrapper;
import ca.eandb.jdcp.job.ParallelizableJob;
import ca.eandb.jdcp.job.TaskWorker;
import ca.eandb.util.UnexpectedException;
import ca.eandb.util.concurrent.BackgroundThreadFactory;
import ca.eandb.util.progress.DummyProgressMonitor;
import ca.eandb.util.progress.DummyProgressMonitorFactory;
import ca.eandb.util.progress.PermanentProgressMonitor;
import ca.eandb.util.progress.ProgressMonitor;
import ca.eandb.util.progress.ProgressMonitorFactory;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;

public final class ParallelizableJobRunner
implements Runnable {
    private final HostService host = new HostService(){

        @Override
        public FileOutputStream createFileOutputStream(String path) {
            File file = new File(ParallelizableJobRunner.this.getWorkingDirectory(), path);
            File directory = file.getParentFile();
            directory.mkdirs();
            try {
                return new FileOutputStream(file);
            }
            catch (FileNotFoundException e) {
                throw new UnexpectedException((Throwable)e);
            }
        }

        @Override
        public RandomAccessFile createRandomAccessFile(String path) {
            File file = new File(ParallelizableJobRunner.this.getWorkingDirectory(), path);
            File directory = file.getParentFile();
            directory.mkdirs();
            try {
                return new RandomAccessFile(file, "rw");
            }
            catch (FileNotFoundException e) {
                throw new UnexpectedException((Throwable)e);
            }
        }
    };
    private static final String TEMP_DIRECTORY_PREFIX = "jdcp-";
    private final ProgressMonitorFactory monitorFactory;
    private final JobExecutionWrapper job;
    private File workingDirectory;
    private final Semaphore workerSlot;
    private final Executor executor;
    private final int maxConcurrentWorkers;
    private final Queue<ProgressMonitor> workerMonitorQueue = new ConcurrentLinkedQueue<ProgressMonitor>();
    private int numProgressMonitors = 0;
    private ProgressMonitor monitor;
    private JobExecutionException workerException = null;

    public static Builder newBuilder() {
        return new Builder();
    }

    public ParallelizableJobRunner(ParallelizableJob job, File workingDirectory, Executor executor, int maxConcurrentWorkers, ProgressMonitorFactory monitorFactory, ProgressMonitor monitor) {
        this.job = new JobExecutionWrapper(job);
        this.workingDirectory = workingDirectory;
        this.executor = executor;
        this.workerSlot = new Semaphore(maxConcurrentWorkers);
        this.maxConcurrentWorkers = maxConcurrentWorkers;
        this.monitorFactory = monitorFactory;
        this.monitor = monitor;
    }

    public ParallelizableJobRunner(ParallelizableJob job, File workingDirectory, int maxConcurrentWorkers, ProgressMonitorFactory monitorFactory, ProgressMonitor monitor) {
        this(job, workingDirectory, Executors.newFixedThreadPool(maxConcurrentWorkers, (ThreadFactory)new BackgroundThreadFactory()), maxConcurrentWorkers, monitorFactory, monitor);
    }

    public ParallelizableJobRunner(ParallelizableJob job, File workingDirectory, Executor executor, int maxConcurrentWorkers) {
        this(job, workingDirectory, executor, maxConcurrentWorkers, (ProgressMonitorFactory)DummyProgressMonitorFactory.getInstance(), (ProgressMonitor)DummyProgressMonitor.getInstance());
    }

    public ParallelizableJobRunner(ParallelizableJob job, String workingDirectory, Executor executor, int maxConcurrentWorkers) {
        this(job, new File(workingDirectory), executor, maxConcurrentWorkers);
    }

    public ParallelizableJobRunner(ParallelizableJob job, File workingDirectory, int maxConcurrentWorkers) {
        this(job, workingDirectory, (Executor)Executors.newFixedThreadPool(maxConcurrentWorkers, (ThreadFactory)new BackgroundThreadFactory()), maxConcurrentWorkers);
    }

    public ParallelizableJobRunner(ParallelizableJob job, String workingDirectory, int maxConcurrentWorkers) {
        this(job, new File(workingDirectory), maxConcurrentWorkers);
    }

    @Override
    public synchronized void run() {
        int taskNumber = 0;
        boolean complete = false;
        try {
            TaskWorker taskWorker = this.job.worker();
            this.job.setHostService(this.host);
            this.job.initialize();
            while (!this.monitor.isCancelPending()) {
                try {
                    this.workerSlot.acquire();
                    if (this.workerException != null) {
                        throw this.workerException;
                    }
                    Object task = this.job.getNextTask();
                    if (task == null) {
                        this.workerSlot.acquire(this.maxConcurrentWorkers - 1);
                        if (this.workerException != null) {
                            throw this.workerException;
                        }
                        complete = true;
                        break;
                    }
                    Worker worker = new Worker(taskWorker, task, this.getWorkerProgressMonitor());
                    this.notifyStatusChanged(String.format("Starting worker %d", ++taskNumber));
                    this.executor.execute(worker);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            this.job.finish();
        }
        catch (JobExecutionException e) {
            throw new RuntimeException(e);
        }
        if (!complete) {
            this.monitor.notifyCancelled();
        } else {
            this.monitor.notifyComplete();
        }
    }

    private synchronized ProgressMonitor getWorkerProgressMonitor() {
        ProgressMonitor monitor;
        if (this.numProgressMonitors < this.maxConcurrentWorkers) {
            String title = String.format("Worker (%d)", this.numProgressMonitors++);
            monitor = new PermanentProgressMonitor(this.monitorFactory.createProgressMonitor(title));
        } else {
            monitor = this.workerMonitorQueue.remove();
        }
        return monitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyStatusChanged(String status) {
        ProgressMonitor progressMonitor = this.monitor;
        synchronized (progressMonitor) {
            this.monitor.notifyStatusChanged(status);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void submitResults(Object task, Object results) throws JobExecutionException {
        ProgressMonitor progressMonitor = this.monitor;
        synchronized (progressMonitor) {
            this.job.submitTaskResults(task, results, this.monitor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setWorkerException(JobExecutionException e) {
        ProgressMonitor progressMonitor = this.monitor;
        synchronized (progressMonitor) {
            if (this.workerException == null) {
                this.workerException = e;
            }
        }
    }

    private synchronized File getWorkingDirectory() {
        if (this.workingDirectory == null) {
            try {
                this.workingDirectory = Files.createTempDirectory(TEMP_DIRECTORY_PREFIX, new FileAttribute[0]).toFile();
            }
            catch (IOException e) {
                throw new UnexpectedException((Throwable)e);
            }
        }
        return this.workingDirectory;
    }

    private class Worker
    implements Runnable {
        private final ProgressMonitor monitor;
        private final Object task;
        private final TaskWorker worker;

        public Worker(TaskWorker worker, Object task, ProgressMonitor monitor) {
            this.worker = worker;
            this.task = task;
            this.monitor = monitor;
        }

        @Override
        public void run() {
            try {
                ParallelizableJobRunner.this.submitResults(this.task, this.worker.performTask(this.task, this.monitor));
            }
            catch (JobExecutionException e) {
                ParallelizableJobRunner.this.setWorkerException(e);
            }
            catch (Exception e) {
                ParallelizableJobRunner.this.setWorkerException(new JobExecutionException(e));
            }
            finally {
                ParallelizableJobRunner.this.workerMonitorQueue.add(this.monitor);
                ParallelizableJobRunner.this.workerSlot.release();
            }
        }
    }

    public static class Builder {
        private ParallelizableJob job = null;
        private File workingDirectory = null;
        private Executor executor = null;
        private int maxConcurrentWorkers = Runtime.getRuntime().availableProcessors();
        private ProgressMonitorFactory progressMonitorFactory = DummyProgressMonitorFactory.getInstance();
        private ProgressMonitor progressMonitor = DummyProgressMonitor.getInstance();

        private Builder() {
        }

        public ParallelizableJobRunner build() throws IOException {
            if (this.job == null) {
                throw new IllegalStateException("Cannot build ParallelizableJobRunner without a job.");
            }
            if (this.executor == null) {
                this.executor = Executors.newFixedThreadPool(this.maxConcurrentWorkers, (ThreadFactory)new BackgroundThreadFactory());
            }
            return new ParallelizableJobRunner(this.job, this.workingDirectory, this.executor, this.maxConcurrentWorkers, this.progressMonitorFactory, this.progressMonitor);
        }

        public Builder setJob(ParallelizableJob job) {
            this.job = job;
            return this;
        }

        public Builder setWorkingDirectory(File workingDirectory) {
            this.workingDirectory = workingDirectory;
            return this;
        }

        public Builder setWorkingDirectory(String workingDirectory) {
            return this.setWorkingDirectory(new File(workingDirectory));
        }

        public Builder setExecutor(Executor executor) {
            this.executor = executor;
            return this;
        }

        public Builder setMaxConcurrentWorkers(int maxConcurrentWorkers) {
            this.maxConcurrentWorkers = maxConcurrentWorkers;
            return this;
        }

        public Builder setProgressMonitorFactory(ProgressMonitorFactory progressMonitorFactory) {
            this.progressMonitorFactory = progressMonitorFactory;
            return this;
        }

        public Builder setProgressMonitor(ProgressMonitor progressMonitor) {
            this.progressMonitor = progressMonitor;
            return this;
        }
    }
}

