/*
 * Decompiled with CFR 0.152.
 */
package ca.eandb.jdcp.job;

import ca.eandb.jdcp.job.HostService;
import ca.eandb.jdcp.job.JobExecutionException;
import ca.eandb.jdcp.job.ParallelizableJob;
import ca.eandb.jdcp.job.TaskWorker;
import ca.eandb.util.progress.ProgressMonitor;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public final class JobExecutionWrapper
implements ParallelizableJob {
    private static final long serialVersionUID = -3231530847968982289L;
    private final ParallelizableJob job;

    public JobExecutionWrapper(ParallelizableJob job) {
        this.job = job;
    }

    @Override
    public void setHostService(HostService host) {
        this.job.setHostService(host);
    }

    @Override
    public void finish() throws JobExecutionException {
        try {
            this.job.finish();
        }
        catch (Exception e) {
            throw new JobExecutionException(e);
        }
    }

    @Override
    public Object getNextTask() throws JobExecutionException {
        try {
            return this.job.getNextTask();
        }
        catch (Exception e) {
            throw new JobExecutionException(e);
        }
    }

    @Override
    public void initialize() throws JobExecutionException {
        try {
            this.job.initialize();
        }
        catch (Exception e) {
            throw new JobExecutionException(e);
        }
    }

    @Override
    public void saveState(ObjectOutput output) throws JobExecutionException {
        try {
            this.job.saveState(output);
        }
        catch (Exception e) {
            throw new JobExecutionException(e);
        }
    }

    @Override
    public void restoreState(ObjectInput input) throws JobExecutionException {
        try {
            this.job.restoreState(input);
        }
        catch (Exception e) {
            throw new JobExecutionException(e);
        }
    }

    @Override
    public boolean isComplete() throws JobExecutionException {
        try {
            return this.job.isComplete();
        }
        catch (Exception e) {
            throw new JobExecutionException(e);
        }
    }

    @Override
    public void submitTaskResults(Object task, Object results, ProgressMonitor monitor) throws JobExecutionException {
        try {
            this.job.submitTaskResults(task, results, monitor);
        }
        catch (Exception e) {
            throw new JobExecutionException(e);
        }
    }

    @Override
    public TaskWorker worker() throws JobExecutionException {
        try {
            return new TaskWorkerWrapper(this.job.worker());
        }
        catch (Exception e) {
            throw new JobExecutionException(e);
        }
    }

    private static final class TaskWorkerWrapper
    implements TaskWorker {
        private static final long serialVersionUID = 997997810158070736L;
        private final TaskWorker inner;

        public TaskWorkerWrapper(TaskWorker inner) {
            this.inner = inner;
        }

        @Override
        public Object performTask(Object task, ProgressMonitor monitor) throws JobExecutionException {
            try {
                return this.inner.performTask(task, monitor);
            }
            catch (Exception e) {
                throw new JobExecutionException(e);
            }
        }
    }
}

