/*
 * Decompiled with CFR 0.152.
 */
package ca.eandb.jdcp.job;

import ca.eandb.jdcp.job.AbstractParallelizableJob;
import ca.eandb.jdcp.job.TaskWorker;
import ca.eandb.util.io.Archive;
import ca.eandb.util.progress.ProgressMonitor;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;

public final class ExceptionTestJob
extends AbstractParallelizableJob
implements Serializable {
    private static final long serialVersionUID = 1608411874454559481L;
    private final TaskWorker worker = new ExceptionTaskWorker();
    private transient int nextTask = 0;
    private transient int tasksComplete = 0;

    @Override
    public Object getNextTask() {
        return this.nextTask < 10 ? Integer.valueOf(this.nextTask++) : null;
    }

    @Override
    public boolean isComplete() {
        return this.nextTask >= 10 && this.tasksComplete == this.nextTask;
    }

    @Override
    public void submitTaskResults(Object task, Object results, ProgressMonitor monitor) {
        System.out.print("Received results for task: ");
        System.out.println(task);
        System.out.print("Results: ");
        System.out.println(results);
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        monitor.notifyProgress(++this.tasksComplete, 10);
    }

    @Override
    public TaskWorker worker() {
        return this.worker;
    }

    @Override
    public void finish() throws IOException {
        PrintStream out = new PrintStream(this.createFileOutputStream("output.txt"));
        out.println("Done");
        out.flush();
        out.close();
    }

    @Override
    protected void archiveState(Archive ar) throws IOException {
        this.nextTask = ar.archiveInt(this.nextTask);
        this.tasksComplete = ar.archiveInt(this.tasksComplete);
    }

    private static final class ExceptionTaskWorker
    implements TaskWorker {
        private static final long serialVersionUID = 1087328238920308359L;

        private ExceptionTaskWorker() {
        }

        @Override
        public Object performTask(Object task, ProgressMonitor monitor) {
            throw new RuntimeException("Throwing an exception...");
        }
    }
}

