/*
 * Decompiled with CFR 0.152.
 */
package ca.eandb.jdcp.job;

import ca.eandb.jdcp.job.AbstractParallelizableJob;
import ca.eandb.jdcp.job.TaskWorker;
import ca.eandb.util.io.Archive;
import ca.eandb.util.progress.ProgressMonitor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Random;

public final class DummyParallelizableJob
extends AbstractParallelizableJob
implements Serializable {
    private static final Random random = new Random();
    private final int minSleepTime;
    private final int maxSleepTime;
    private final int tasks;
    private transient int nextTask = 0;
    private transient int numResultsReceived = 0;
    private final TaskWorker worker = new TaskWorker(){
        private static final long serialVersionUID = -4687914341839279922L;

        @Override
        public Object performTask(Object task, ProgressMonitor monitor) {
            int value = (Integer)task;
            String msg = String.format("Processing task %d.", value);
            monitor.notifyStatusChanged(msg);
            System.out.println(msg);
            int sleepTime = DummyParallelizableJob.this.minSleepTime + random.nextInt(DummyParallelizableJob.this.maxSleepTime - DummyParallelizableJob.this.minSleepTime + 1);
            try {
                Thread.sleep(sleepTime);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            msg = String.format("Done task %d.", value);
            monitor.notifyStatusChanged(msg);
            System.out.println(msg);
            return value;
        }
    };
    private static final long serialVersionUID = 4328712633325360415L;

    public DummyParallelizableJob(int tasks, int minSleepTime, int maxSleepTime) {
        this.tasks = tasks;
        this.minSleepTime = minSleepTime;
        this.maxSleepTime = maxSleepTime;
        assert (minSleepTime <= maxSleepTime);
    }

    @Override
    public Object getNextTask() {
        if (this.nextTask < this.tasks) {
            System.out.printf("Task %d requested.\n", this.nextTask);
            return this.nextTask++;
        }
        System.out.println("No more tasks.");
        return null;
    }

    @Override
    public void submitTaskResults(Object task, Object results, ProgressMonitor monitor) {
        int taskValue = (Integer)task;
        int resultValue = (Integer)results;
        System.out.printf("Received results for task %d: %d.\n", taskValue, resultValue);
        monitor.notifyProgress(++this.numResultsReceived, this.tasks);
    }

    @Override
    public boolean isComplete() {
        return this.numResultsReceived >= this.tasks;
    }

    @Override
    public void finish() {
        FileOutputStream stream = this.createFileOutputStream("results.txt");
        PrintStream results = new PrintStream(stream);
        results.printf("DummyParallelizableJob complete (%d tasks).\n", this.tasks);
        results.flush();
        results.close();
    }

    @Override
    public TaskWorker worker() {
        return this.worker;
    }

    @Override
    protected void archiveState(Archive ar) throws IOException {
        this.nextTask = ar.archiveInt(this.nextTask);
        this.numResultsReceived = ar.archiveInt(this.numResultsReceived);
    }
}

