/*
 * Decompiled with CFR 0.152.
 */
package ca.eandb.jdcp.job;

import ca.eandb.jdcp.job.HostService;
import ca.eandb.jdcp.job.LifeCycleManageable;
import ca.eandb.jdcp.job.ParallelizableJob;
import ca.eandb.jdcp.job.TaskWorker;
import ca.eandb.util.progress.CancelListener;
import ca.eandb.util.progress.ProgressMonitor;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public final class CompositeParallelizableJob
implements ParallelizableJob {
    private static final long serialVersionUID = 2314913595545088051L;
    private final List<ParallelizableJob> jobs = new ArrayList<ParallelizableJob>();
    private transient TaskWorker worker = null;
    private transient double[] jobProgress = null;
    private transient double totalProgress = 0.0;

    public CompositeParallelizableJob() {
    }

    public CompositeParallelizableJob(Collection<ParallelizableJob> jobs) {
        this.jobs.addAll(jobs);
    }

    public CompositeParallelizableJob addJob(ParallelizableJob job) {
        this.jobs.add(job);
        return this;
    }

    public CompositeParallelizableJob addJobs(Collection<ParallelizableJob> jobs) {
        this.jobs.addAll(jobs);
        return this;
    }

    @Override
    public void setHostService(HostService host) {
        for (ParallelizableJob job : this.jobs) {
            job.setHostService(host);
        }
    }

    @Override
    public void initialize() throws Exception {
        for (LifeCycleManageable lifeCycleManageable : this.jobs) {
            lifeCycleManageable.initialize();
        }
    }

    @Override
    public void finish() throws Exception {
    }

    @Override
    public void saveState(ObjectOutput output) throws Exception {
        for (LifeCycleManageable lifeCycleManageable : this.jobs) {
            lifeCycleManageable.saveState(output);
        }
    }

    @Override
    public void restoreState(ObjectInput input) throws Exception {
        for (LifeCycleManageable lifeCycleManageable : this.jobs) {
            lifeCycleManageable.restoreState(input);
        }
    }

    @Override
    public Object getNextTask() throws Exception {
        int n = this.jobs.size();
        for (int i = 0; i < n; ++i) {
            ParallelizableJob job = this.jobs.get(i);
            Object task = job.getNextTask();
            if (task == null) continue;
            return new JobItem(i, task);
        }
        return null;
    }

    @Override
    public void submitTaskResults(Object task_, Object results, ProgressMonitor monitor) throws Exception {
        JobItem task = (JobItem)task_;
        ParallelizableJob job = this.jobs.get(task.jobNumber);
        job.submitTaskResults(task.item, results, new CompositeProgressMonitor(task.jobNumber));
        if (job.isComplete()) {
            job.finish();
        }
        monitor.notifyProgress(this.totalProgress);
    }

    @Override
    public boolean isComplete() throws Exception {
        for (ParallelizableJob job : this.jobs) {
            if (job.isComplete()) continue;
            return false;
        }
        return true;
    }

    @Override
    public synchronized TaskWorker worker() throws Exception {
        if (this.worker == null) {
            int njobs = this.jobs.size();
            TaskWorker[] workers = new TaskWorker[njobs];
            for (int i = 0; i < njobs; ++i) {
                workers[i] = this.jobs.get(i).worker();
            }
            this.worker = new CompositeTaskWorker(workers);
        }
        return this.worker;
    }

    static /* synthetic */ double[] access$002(CompositeParallelizableJob x0, double[] x1) {
        x0.jobProgress = x1;
        return x1;
    }

    private static final class CompositeTaskWorker
    implements TaskWorker {
        private static final long serialVersionUID = -9185015559500365734L;
        private final TaskWorker[] workers;

        public CompositeTaskWorker(TaskWorker[] workers) {
            this.workers = workers;
        }

        @Override
        public Object performTask(Object task_, ProgressMonitor monitor) throws Exception {
            JobItem task = (JobItem)task_;
            return this.workers[task.jobNumber].performTask(task.item, monitor);
        }
    }

    private static final class JobItem
    implements Serializable {
        private static final long serialVersionUID = 3197453751237018890L;
        public final int jobNumber;
        public final Object item;

        public JobItem(int jobNumber, Object item) {
            this.jobNumber = jobNumber;
            this.item = item;
        }
    }

    private final class CompositeProgressMonitor
    implements ProgressMonitor {
        private final int jobNumber;

        public CompositeProgressMonitor(int jobNumber) {
            this.jobNumber = jobNumber;
        }

        public boolean notifyProgress(int value, int maximum) {
            return this.notifyProgress((double)value / (double)maximum);
        }

        public synchronized boolean notifyProgress(double progress) {
            if (CompositeParallelizableJob.this.jobProgress == null) {
                CompositeParallelizableJob.access$002(CompositeParallelizableJob.this, new double[CompositeParallelizableJob.this.jobs.size()]);
            }
            CompositeParallelizableJob.this.totalProgress = CompositeParallelizableJob.this.totalProgress + (progress - CompositeParallelizableJob.this.jobProgress[this.jobNumber]) / (double)CompositeParallelizableJob.this.jobs.size();
            ((CompositeParallelizableJob)CompositeParallelizableJob.this).jobProgress[this.jobNumber] = progress;
            return true;
        }

        public boolean notifyIndeterminantProgress() {
            return true;
        }

        public void notifyComplete() {
            this.notifyProgress(1.0);
        }

        public void notifyCancelled() {
        }

        public void notifyStatusChanged(String status) {
        }

        public boolean isCancelPending() {
            return false;
        }

        public void addCancelListener(CancelListener listener) {
        }
    }
}

