/*
 * Decompiled with CFR 0.152.
 */
package ca.eandb.jdcp;

import ca.eandb.jdcp.job.HostService;
import ca.eandb.jdcp.job.JobExecutionException;
import ca.eandb.jdcp.job.ParallelizableJob;
import ca.eandb.jdcp.remote.AuthenticationService;
import ca.eandb.jdcp.remote.JobService;
import ca.eandb.jdcp.remote.ProtocolVersionException;
import ca.eandb.jdcp.remote.TaskService;
import ca.eandb.jdcp.server.ServerUtil;
import ca.eandb.util.io.FileUtil;
import ca.eandb.util.rmi.Serialized;
import java.io.File;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.UUID;
import javax.security.auth.login.LoginException;

public final class JdcpUtil {
    public static final int DEFAULT_PORT = 5327;
    public static final UUID PROTOCOL_VERSION_ID = UUID.fromString("32f63a29-642d-4ff3-84a4-b1f34940642a");

    public static JobService connect(String host, String username, String password) throws RemoteException, NotBoundException, LoginException, ProtocolVersionException {
        Registry registry = LocateRegistry.getRegistry(host, 5327);
        AuthenticationService auth = (AuthenticationService)registry.lookup("AuthenticationService");
        return auth.authenticate(username, password, PROTOCOL_VERSION_ID);
    }

    public static UUID submitJob(ParallelizableJob job, String description, String host, String username, String password) throws SecurityException, RemoteException, ClassNotFoundException, JobExecutionException, LoginException, NotBoundException, ProtocolVersionException {
        Serialized payload = new Serialized((Object)job);
        JobService service = JdcpUtil.connect(host, username, password);
        return service.submitJob((Serialized<ParallelizableJob>)payload, description);
    }

    public static void registerTaskService(String name, TaskService taskService, String host, String username, String password) throws SecurityException, RemoteException, ClassNotFoundException, JobExecutionException, LoginException, NotBoundException, ProtocolVersionException {
        JobService service = JdcpUtil.connect(host, username, password);
        service.registerTaskService(name, taskService);
    }

    public static HostService getHostService() {
        return ServerUtil.getHostService();
    }

    public static File getHomeDirectory() {
        JdcpUtil.initialize();
        return new File(System.getProperty("jdcp.home"));
    }

    public static void initialize() {
        File homeDir;
        String homeDirName = System.getProperty("jdcp.home");
        if (homeDirName != null) {
            homeDir = new File(homeDirName);
        } else {
            homeDir = FileUtil.getApplicationDataDirectory((String)"jdcp");
            System.setProperty("jdcp.home", homeDir.getPath());
        }
        homeDir.mkdir();
        if (System.getProperty("derby.system.home") == null) {
            System.setProperty("derby.system.home", homeDir.getPath());
        }
    }

    private JdcpUtil() {
    }
}

