/*
 * Decompiled with CFR 0.152.
 */
package ca.derekcormier.recipe;

import ca.derekcormier.recipe.Ingredient;
import ca.derekcormier.recipe.KeyedIngredient;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Recipe
extends Ingredient {
    @JsonProperty(value="ingredients")
    private final List<Ingredient> ingredients = new ArrayList<Ingredient>();
    @JsonProperty(value="context")
    private String context;

    protected Recipe() {
        super("Recipe");
    }

    protected Recipe(Ingredient ... ingredients) {
        super("Recipe");
        for (Ingredient ingredient : ingredients) {
            if (ingredient instanceof Recipe && ((Recipe)ingredient).context == null) {
                this.ingredients.addAll(((Recipe)ingredient).ingredients);
                continue;
            }
            this.ingredients.add(ingredient);
        }
    }

    public static Recipe prepare(Ingredient ... ingredients) {
        return new Recipe(ingredients);
    }

    public static Recipe context(String context, Ingredient ... ingredients) {
        Recipe recipe = Recipe.prepare(ingredients);
        recipe.context = context;
        return recipe;
    }

    public static Recipe context(KeyedIngredient contextIngredient, Ingredient ... ingredients) {
        Objects.requireNonNull(contextIngredient);
        return Recipe.prepare(contextIngredient, Recipe.context(contextIngredient.getKey(), ingredients));
    }

    public List<Ingredient> getIngredients() {
        return this.ingredients;
    }

    public String getContext() {
        return this.context;
    }

    protected List<Segment> segment() {
        ArrayList<Segment> segments = new ArrayList<Segment>();
        ArrayList<Recipe> recipeStack = new ArrayList<Recipe>();
        recipeStack.add(this);
        this._segment(new Recipe(), recipeStack, null, segments);
        return segments;
    }

    private void _segment(Recipe currRecipe, List<Recipe> recipeStack, String currDomain, List<Segment> segments) {
        for (Ingredient ingredient : recipeStack.get((int)0).ingredients) {
            if (ingredient instanceof Recipe) {
                Recipe recipe = new Recipe();
                recipe.context = ((Recipe)ingredient).context;
                recipeStack.add(0, (Recipe)ingredient);
                this._segment(recipe, recipeStack, currDomain, segments);
                if (recipe.ingredients.isEmpty()) continue;
                currRecipe.ingredients.add(recipe);
                continue;
            }
            if (!ingredient.getDomain().equals(currDomain)) {
                Recipe outerRecipe = null;
                Recipe recipe = null;
                for (Recipe r : recipeStack) {
                    if (recipe == null) {
                        recipe = outerRecipe = new Recipe();
                    } else {
                        outerRecipe = Recipe.prepare(outerRecipe);
                    }
                    outerRecipe.context = r.context;
                }
                Segment segmented = new Segment();
                segmented.domain = ingredient.getDomain();
                segmented.recipe = outerRecipe;
                segments.add(segmented);
                currRecipe = recipe;
                currDomain = ingredient.getDomain();
            }
            currRecipe.ingredients.add(ingredient);
        }
        recipeStack.remove(0);
    }

    public class Segment {
        public String domain;
        public Recipe recipe;
    }
}

