/*
 * Decompiled with CFR 0.152.
 */
package ca.derekcormier.recipe;

import ca.derekcormier.recipe.AbstractOven;
import ca.derekcormier.recipe.Cake;
import ca.derekcormier.recipe.Dispatcher;
import ca.derekcormier.recipe.Ingredient;
import ca.derekcormier.recipe.Payload;
import ca.derekcormier.recipe.Recipe;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.jsontype.SubtypeResolver;
import com.fasterxml.jackson.databind.jsontype.impl.StdSubtypeResolver;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Oven
extends AbstractOven {
    private Dispatcher defaultDispatcher;
    private Map<String, Dispatcher> dispatchers = new HashMap<String, Dispatcher>();
    private ObjectMapper objectMapper;
    private SubtypeResolver subtypeResolver;

    public Cake bake(Recipe recipe) {
        this.subtypeResolver = new StdSubtypeResolver();
        this.registerSubtypes(recipe);
        this.objectMapper = new ObjectMapper();
        this.objectMapper.setSubtypeResolver(this.subtypeResolver);
        Cake cake = this._bake(recipe, this.createCake());
        return cake;
    }

    private Cake _bake(Recipe recipe, Cake cake) {
        try {
            List<Recipe.Segment> segments = recipe.segment();
            for (Recipe.Segment segment : segments) {
                String jsonCake;
                String payload = this.serializePayload(segment.recipe, cake);
                if (this.dispatchers.containsKey(segment.domain)) {
                    jsonCake = this.dispatchers.get(segment.domain).dispatch(payload);
                    cake = this.deserializeCake(jsonCake);
                    continue;
                }
                if (this.defaultDispatcher != null) {
                    jsonCake = this.defaultDispatcher.dispatch(payload);
                    cake = this.deserializeCake(jsonCake);
                    continue;
                }
                throw new RuntimeException("cannot dispatch ingredient; no dispatcher registered for domain '" + segment.domain + "'");
            }
            return cake;
        }
        catch (Exception e) {
            throw new RuntimeException("could not bake cake", e);
        }
    }

    public void addDispatcher(String domain, Dispatcher dispatcher) {
        if (this.dispatchers.containsKey(domain)) {
            throw new RuntimeException("oven already has a dispatcher for domain '" + domain + "'");
        }
        this.dispatchers.put(domain, dispatcher);
    }

    public void setDefaultDispatcher(Dispatcher dispatcher) {
        this._setDefaultDispatcher(dispatcher);
    }

    protected void _setDefaultDispatcher(Dispatcher dispatcher) {
        this.defaultDispatcher = dispatcher;
    }

    private String serializePayload(Recipe recipe, Cake cake) throws JsonProcessingException {
        Cake plainCake = new Cake(cake);
        Payload payload = new Payload(recipe, plainCake);
        return this.objectMapper.writeValueAsString((Object)payload);
    }

    private Cake deserializeCake(String json) throws IOException {
        Cake plainCake = (Cake)this.objectMapper.readValue(json, Cake.class);
        return this.createCake(plainCake);
    }

    private void registerSubtypes(Recipe recipe) {
        for (Ingredient ingredient : recipe.getIngredients()) {
            if (ingredient instanceof Recipe) {
                this.registerSubtypes((Recipe)ingredient);
                continue;
            }
            this.subtypeResolver.registerSubtypes(new NamedType[]{new NamedType(ingredient.getClass(), ingredient.getIngredientType())});
        }
    }
}

