/*
 * Decompiled with CFR 0.152.
 */
package ca.derekcormier.recipe;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.WRAPPER_OBJECT)
public abstract class Ingredient {
    private final Map<String, Object> properties = new HashMap<String, Object>();
    @JsonIgnore
    private final String ingredientType;
    @JsonIgnore
    private final String domain;

    public Ingredient(String ingredientType, String domain) {
        this.ingredientType = ingredientType;
        this.domain = domain;
    }

    public Ingredient(String ingredientType) {
        this(ingredientType, "");
    }

    protected Ingredient(Ingredient other) {
        this(other.getIngredientType(), other.getDomain());
        other.getProperties().forEach((key, value) -> this.setProperty((String)key, value));
    }

    public String getDomain() {
        return this.domain;
    }

    public String getIngredientType() {
        return this.ingredientType;
    }

    protected void setRequired(String name, Object value) {
        this.setProperty(name, value);
    }

    protected void setOptional(String name, boolean repeatable, Object value) {
        if (!repeatable) {
            this.setProperty(name, value);
        } else {
            List values = this.getProperties().getOrDefault(name, new ArrayList());
            values.add(value);
            this.setProperty(name, values);
        }
    }

    protected void setCompoundOptional(String name, boolean repeatable, Object ... keyValuePairs) {
        if (keyValuePairs.length % 2 != 0) {
            throw new IllegalArgumentException("must have an even number of key-value pairs for compound optional");
        }
        for (int i = 0; i < keyValuePairs.length; i += 2) {
            if (keyValuePairs[i] instanceof String) continue;
            throw new IllegalArgumentException("key in compound optional is not a string");
        }
        if (!repeatable) {
            Map map = this.getProperties().getOrDefault(name, new HashMap());
            for (int i = 0; i < keyValuePairs.length; i += 2) {
                map.put(keyValuePairs[i], keyValuePairs[i + 1]);
            }
            this.setProperty(name, map);
        } else {
            List list = this.getProperties().getOrDefault(name, new ArrayList());
            HashMap<Object, Object> map = new HashMap<Object, Object>();
            for (int i = 0; i < keyValuePairs.length; i += 2) {
                map.put(keyValuePairs[i], keyValuePairs[i + 1]);
            }
            list.add(map);
            this.setProperty(name, list);
        }
    }

    @JsonAnySetter
    protected void setProperty(String key, Object value) {
        this.properties.put(key, value);
    }

    protected <T> T getProperty(String key) {
        return (T)this.properties.get(key);
    }

    protected <T> T getProperty(Class<T> clazz, String key) {
        if (this.hasProperty(key)) {
            return this.getProperty(key);
        }
        if (clazz == Integer.TYPE) {
            return (T)new Integer(0);
        }
        if (clazz == Float.TYPE) {
            return (T)new Float(0.0f);
        }
        if (clazz == Boolean.TYPE) {
            return (T)new Boolean(false);
        }
        if (clazz == String.class) {
            return null;
        }
        if (clazz.isEnum()) {
            return clazz.getEnumConstants()[0];
        }
        if (clazz.isArray()) {
            return (T)Array.newInstance(clazz.getComponentType(), 0);
        }
        return null;
    }

    protected boolean hasProperty(String key) {
        return this.properties.containsKey(key);
    }

    @JsonAnyGetter
    protected Map<String, Object> getProperties() {
        return this.properties;
    }
}

