/*
 * Decompiled with CFR 0.152.
 */
package ca.derekcormier.recipe;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class Cake {
    public static final String SEPARATOR = ".";
    private final Map<String, Object> entries = new HashMap<String, Object>();
    private final LinkedList<String> prefixStack = new LinkedList();

    public Cake() {
    }

    public Cake(Cake other) {
        this.entries.putAll(other.entries);
    }

    public static String key(String ... subKeys) {
        if (subKeys.length == 0) {
            throw new IllegalArgumentException("cannot form cake key; no keys supplied");
        }
        Arrays.asList(subKeys).forEach(Cake::validateKey);
        return StringUtils.join((Object[])subKeys, (String)SEPARATOR);
    }

    private static void validateKey(String key) {
        if (StringUtils.isBlank((CharSequence)key)) {
            throw new IllegalArgumentException("keys cannot be empty");
        }
        if (key.contains(SEPARATOR)) {
            throw new IllegalArgumentException("keys cannot contain the namespace separator: .");
        }
    }

    public <T> T get(String ... key) {
        List<String> keys = (key == null ? new ArrayList() : Arrays.asList(key)).stream().flatMap(k -> {
            String[] stringArray;
            if (k == null) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = null;
            } else {
                stringArray = StringUtils.split((String)k, (String)SEPARATOR);
            }
            return Arrays.stream(stringArray);
        }).collect(Collectors.toList());
        if (keys.isEmpty()) {
            throw new IllegalArgumentException("cannot get value for empty key");
        }
        keys.forEach(Cake::validateKey);
        String fullKey = StringUtils.join(keys, (String)SEPARATOR);
        String searchKey = this.getPrefixWithSeparator(this.prefixStack) + fullKey;
        if (this.entries.containsKey(searchKey)) {
            return (T)this.entries.get(searchKey);
        }
        LinkedList<String> namespaces = new LinkedList<String>(this.prefixStack);
        while (!namespaces.isEmpty()) {
            namespaces.removeLast();
            searchKey = this.getPrefixWithSeparator(namespaces) + fullKey;
            if (!this.entries.containsKey(searchKey)) continue;
            return (T)this.entries.get(searchKey);
        }
        List candidates = this.entries.keySet().stream().filter(k -> {
            String[] subkeys = StringUtils.split((String)k, (String)SEPARATOR);
            if (keys.size() > subkeys.length) {
                return false;
            }
            for (int i = 0; i < keys.size(); ++i) {
                if (((String)keys.get(keys.size() - 1 - i)).equals(subkeys[subkeys.length - 1 - i])) continue;
                return false;
            }
            return true;
        }).collect(Collectors.toList());
        if (candidates.size() == 1) {
            return (T)this.entries.get(candidates.get(0));
        }
        if (candidates.isEmpty()) {
            throw new RuntimeException("cake does not contain key '" + fullKey + "; current keys: " + this.entries.keySet());
        }
        throw new RuntimeException("cannot retrieve ambiguous key '" + fullKey + "'; candidates: " + candidates);
    }

    public <T> T get(Class<T> clazz, String ... key) {
        return clazz.cast(this.get(key));
    }

    public void publish(String key, Object value) {
        this.getSubKeysAndValidateFullKey(key);
        String newKey = this.getPrefixWithSeparator(this.prefixStack) + key;
        this.entries.put(newKey, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void inNamespace(String key, Runnable runnable) {
        List<String> keys = this.getSubKeysAndValidateFullKey(key);
        keys.forEach(this.prefixStack::addLast);
        try {
            runnable.run();
        }
        finally {
            keys.forEach(k -> this.prefixStack.removeLast());
        }
    }

    public String getPublishedKeyForValue(Object value, boolean fullyQualified) {
        List matchingKeys = this.entries.entrySet().stream().filter(e -> e.getValue().equals(value)).map(Map.Entry::getKey).collect(Collectors.toList());
        if (matchingKeys.size() == 1) {
            if (fullyQualified) {
                return (String)matchingKeys.get(0);
            }
            String[] splitKey = StringUtils.split((String)((String)matchingKeys.get(0)), (String)SEPARATOR);
            return splitKey[splitKey.length - 1];
        }
        if (matchingKeys.size() > 1) {
            throw new IllegalArgumentException("multiple keys found for object " + value);
        }
        throw new IllegalArgumentException("no key found for object " + value);
    }

    @JsonIgnore
    public String getNamespace() {
        return StringUtils.join(this.prefixStack, (String)SEPARATOR);
    }

    public boolean hasContext() {
        try {
            this.getContext();
            return true;
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    @JsonIgnore
    public <T> T getContext() {
        if (this.prefixStack.isEmpty()) {
            throw new IllegalStateException("cannot get context in root namespace");
        }
        String prefix = this.getPrefixWithSeparator(this.prefixStack);
        if (!this.entries.containsKey(prefix = prefix.substring(0, prefix.length() - 1))) {
            throw new RuntimeException("cake does not contain context value for namespace " + prefix);
        }
        return (T)this.entries.get(prefix);
    }

    @JsonIgnore
    public <T> T getContext(Class<T> clazz) {
        return clazz.cast(this.getContext());
    }

    @JsonIgnore
    public <T> T getOrGetContext(String ... key) {
        try {
            return this.get(key);
        }
        catch (RuntimeException e) {
            return this.getContext();
        }
    }

    @JsonIgnore
    public <T> T getOrGetContext(Class<T> clazz, String ... key) {
        try {
            return clazz.cast(this.get(key));
        }
        catch (RuntimeException e) {
            return clazz.cast(this.getContext());
        }
    }

    private List<String> getSubKeysAndValidateFullKey(String fullKey) {
        List<Object> keys;
        List<Object> list = keys = null == fullKey ? new ArrayList() : Arrays.asList(StringUtils.split((String)fullKey, (String)SEPARATOR));
        if (keys.isEmpty() || StringUtils.countMatches((CharSequence)fullKey, (CharSequence)SEPARATOR) != keys.size() - 1) {
            throw new IllegalArgumentException("cannot publish value for empty key");
        }
        keys.forEach(Cake::validateKey);
        return keys;
    }

    private String getPrefixWithSeparator(List<String> namespaces) {
        return StringUtils.join(namespaces, (String)SEPARATOR) + (namespaces.size() > 0 ? SEPARATOR : "");
    }

    @JsonAnyGetter
    protected Map<String, Object> getEntries() {
        return this.entries;
    }

    @JsonAnySetter
    private void setEntry(String key, Object value) {
        this.entries.put(key, value);
    }
}

