/*
 * Decompiled with CFR 0.152.
 */
package ca.derekcormier.recipe;

import ca.derekcormier.recipe.AbstractOven;
import ca.derekcormier.recipe.BaseIngredientHook;
import ca.derekcormier.recipe.Cake;
import ca.derekcormier.recipe.Ingredient;
import ca.derekcormier.recipe.Payload;
import ca.derekcormier.recipe.Recipe;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.jsontype.SubtypeResolver;
import com.fasterxml.jackson.databind.jsontype.impl.StdSubtypeResolver;
import java.util.HashMap;
import java.util.Map;

public class BackendOven
extends AbstractOven {
    private final Map<String, BaseIngredientHook> hooks = new HashMap<String, BaseIngredientHook>();
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final SubtypeResolver subtypeResolver = new StdSubtypeResolver();

    public BackendOven() {
        this.objectMapper.setSubtypeResolver(this.subtypeResolver);
        this.subtypeResolver.registerSubtypes(new NamedType[]{new NamedType(Recipe.class, "Recipe")});
    }

    public String bake(String json) {
        try {
            Payload payload = (Payload)this.objectMapper.readValue(json, Payload.class);
            Cake cake = this.createCake(payload.getCake());
            this.bakeIngredient(payload.getRecipe(), cake);
            Cake cakeToSerialize = new Cake(cake);
            return this.objectMapper.writeValueAsString((Object)cakeToSerialize);
        }
        catch (Exception e) {
            throw new RuntimeException("payload serialization error", e);
        }
    }

    public void registerHook(BaseIngredientHook hook) {
        this.hooks.put(hook.getIngredientName(), hook);
        this.subtypeResolver.registerSubtypes(new NamedType[]{new NamedType(hook.getDataClass(), hook.getIngredientName())});
    }

    private void bakeIngredient(Ingredient ingredient, Cake cake) {
        if (ingredient instanceof Recipe) {
            Recipe recipe = (Recipe)ingredient;
            Runnable bakeRecipeIngredients = () -> {
                for (Ingredient i : recipe.getIngredients()) {
                    this.bakeIngredient(i, cake);
                }
            };
            if (recipe.getContext() != null) {
                cake.inNamespace(recipe.getContext(), bakeRecipeIngredients);
            } else {
                bakeRecipeIngredients.run();
            }
        } else {
            this.hooks.get(ingredient.getIngredientType()).bake(ingredient, cake);
        }
    }
}

