/*
 * Decompiled with CFR 0.152.
 */
package ca.derekcormier.recipe;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Map;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.WRAPPER_OBJECT)
public abstract class BaseIngredient {
    private final Map<String, Object> properties = new HashMap<String, Object>();
    @JsonIgnore
    private final String ingredientType;
    @JsonIgnore
    private final String domain;

    public BaseIngredient(String ingredientType, String domain) {
        this.ingredientType = ingredientType;
        this.domain = domain;
    }

    public BaseIngredient(String ingredientType) {
        this(ingredientType, "");
    }

    public String getDomain() {
        return this.domain;
    }

    public String getIngredientType() {
        return this.ingredientType;
    }

    @JsonAnySetter
    protected void setProperty(String key, Object value) {
        this.properties.put(key, value);
    }

    protected <T> T getProperty(String key) {
        return (T)this.properties.get(key);
    }

    protected <T> T getProperty(Class<T> clazz, String key) {
        if (this.hasProperty(key)) {
            return this.getProperty(key);
        }
        if (clazz == Integer.TYPE) {
            return (T)new Integer(0);
        }
        if (clazz == Float.TYPE) {
            return (T)new Float(0.0f);
        }
        if (clazz == Boolean.TYPE) {
            return (T)new Boolean(false);
        }
        if (clazz == String.class) {
            return null;
        }
        if (clazz.isEnum()) {
            return clazz.getEnumConstants()[0];
        }
        if (clazz.isArray()) {
            return (T)Array.newInstance(clazz.getComponentType(), 0);
        }
        return null;
    }

    protected boolean hasProperty(String key) {
        return this.properties.containsKey(key);
    }

    @JsonAnyGetter
    protected Map<String, Object> getProperties() {
        return this.properties;
    }
}

