/*
 * Decompiled with CFR 0.152.
 */
package ca.derekcormier.recipe;

import ca.derekcormier.recipe.Cake;
import ca.derekcormier.recipe.Dispatcher;
import ca.derekcormier.recipe.Ingredient;
import ca.derekcormier.recipe.Payload;
import ca.derekcormier.recipe.Recipe;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.jsontype.SubtypeResolver;
import com.fasterxml.jackson.databind.jsontype.impl.StdSubtypeResolver;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Oven {
    private Map<String, Dispatcher> dispatchers = new HashMap<String, Dispatcher>();
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final SubtypeResolver subtypeResolver = new StdSubtypeResolver();

    public Oven() {
        this.objectMapper.setSubtypeResolver(this.subtypeResolver);
    }

    public Cake bake(Recipe recipe) {
        this.registerSubtypes(recipe);
        Cake cake = this._bake(recipe, new Cake());
        return cake;
    }

    private Cake _bake(Recipe recipe, Cake cake) {
        try {
            List<Recipe.Segment> segments = recipe.segment();
            for (Recipe.Segment segment : segments) {
                String payload = this.serializePayload(segment.recipe, cake);
                if (!this.dispatchers.containsKey(segment.domain)) {
                    throw new RuntimeException("cannot dispatch ingredient; no dispatcher registered for domain '" + segment.domain + "'");
                }
                String jsonCake = this.dispatchers.get(segment.domain).dispatch(payload);
                cake = this.deserializeCake(jsonCake);
            }
            return cake;
        }
        catch (Exception e) {
            throw new RuntimeException("could not bake cake", e);
        }
    }

    public void addDispatcher(String domain, Dispatcher dispatcher) {
        if (this.dispatchers.containsKey(domain)) {
            throw new RuntimeException("oven already has a dispatcher for domain '" + domain + "'");
        }
        this.dispatchers.put(domain, dispatcher);
    }

    private String serializePayload(Recipe recipe, Cake cake) throws JsonProcessingException {
        Payload payload = new Payload(recipe, cake);
        return this.objectMapper.writeValueAsString((Object)payload);
    }

    private Cake deserializeCake(String json) throws IOException {
        return (Cake)this.objectMapper.readValue(json, Cake.class);
    }

    private void registerSubtypes(Recipe recipe) {
        if (recipe.getContextIngredient() != null) {
            this.subtypeResolver.registerSubtypes(new NamedType[]{new NamedType(recipe.getContextIngredient().getClass(), recipe.getContextIngredient().getIngredientType())});
        }
        for (Ingredient ingredient : recipe.getIngredients()) {
            if (ingredient instanceof Recipe) {
                this.registerSubtypes((Recipe)ingredient);
                continue;
            }
            this.subtypeResolver.registerSubtypes(new NamedType[]{new NamedType(ingredient.getClass(), ingredient.getIngredientType())});
        }
    }
}

