/*
 * Decompiled with CFR 0.152.
 */
package ca.derekcormier.recipe;

import ca.derekcormier.recipe.BaseIngredient;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class Ingredient
extends BaseIngredient {
    public Ingredient(String type) {
        this(type, "");
    }

    public Ingredient(String type, String domain) {
        super(type, domain);
    }

    protected void setRequired(String name, Object value) {
        this.setProperty(name, value);
    }

    protected void setOptional(String name, boolean repeatable, Object value) {
        if (!repeatable) {
            this.setProperty(name, value);
        } else {
            List values = this.getProperties().getOrDefault(name, new ArrayList());
            values.add(value);
            this.setProperty(name, values);
        }
    }

    protected void setCompoundOptional(String name, boolean repeatable, Object ... keyValuePairs) {
        if (keyValuePairs.length % 2 != 0) {
            throw new IllegalArgumentException("must have an even number of key-value pairs for compound optional");
        }
        for (int i = 0; i < keyValuePairs.length; i += 2) {
            if (keyValuePairs[i] instanceof String) continue;
            throw new IllegalArgumentException("key in compound optional is not a string");
        }
        if (!repeatable) {
            Map map = this.getProperties().getOrDefault(name, new HashMap());
            for (int i = 0; i < keyValuePairs.length; i += 2) {
                map.put(keyValuePairs[i], keyValuePairs[i + 1]);
            }
            this.setProperty(name, map);
        } else {
            List list = this.getProperties().getOrDefault(name, new ArrayList());
            HashMap<Object, Object> map = new HashMap<Object, Object>();
            for (int i = 0; i < keyValuePairs.length; i += 2) {
                map.put(keyValuePairs[i], keyValuePairs[i + 1]);
            }
            list.add(map);
            this.setProperty(name, list);
        }
    }
}

