/*
 * Decompiled with CFR 0.152.
 */
package ca.derekcormier.recipe.generator;

import ca.derekcormier.recipe.cookbook.Cookbook;
import ca.derekcormier.recipe.cookbook.CookbookUtils;
import ca.derekcormier.recipe.cookbook.Enum;
import ca.derekcormier.recipe.cookbook.Ingredient;
import ca.derekcormier.recipe.generator.JavaScriptHookGenerator;
import ca.derekcormier.recipe.generator.TypeScriptGenerator;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TypeScriptHookGenerator
extends TypeScriptGenerator {
    public TypeScriptHookGenerator(Cookbook cookbook) {
        super(cookbook);
    }

    @Override
    public void generate(String domain, String targetDir, Map<String, Object> options) {
        options.put("runtimeLibrary", "recipe-ts-runtime");
        String directory = this.createDirectories(targetDir);
        new JavaScriptHookGenerator(this.getCookbook()).generate(domain, targetDir, options);
        this.generateAbstractHookTypes(directory, options);
        this.generateIngredientDataSnapshotTypes(directory, options, domain);
        this.generateEnumTypes(directory, options);
        this.generateIndexTypes(directory);
    }

    private void generateAbstractHookTypes(String directory, Map<String, Object> options) {
        if (!this.getCookbook().getIngredients().isEmpty()) {
            System.out.println("Generating ingredient hook types in " + directory + "...");
        }
        for (Ingredient ingredient : this.getCookbook().getIngredients()) {
            HashMap<String, List<String>> info = new HashMap<String, List<String>>();
            info.put("constantKeys", this.getConstantKeyValueArrays(ingredient).get(0));
            info.put("constantValues", this.getConstantKeyValueArrays(ingredient).get(1));
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("ingredient", ingredient);
            data.put("options", options);
            data.put("info", info);
            String rendered = this.renderTemplate("templates/ts/hook-types.liquid", data);
            String filepath = directory + File.separator + "Abstract" + ingredient.getName() + "Hook.d.ts";
            this.writeToFile(filepath, rendered);
            System.out.println("  -> Abstract" + ingredient.getName() + "Hook.d.ts");
        }
    }

    private void generateIngredientDataSnapshotTypes(String directory, Map<String, Object> options, String domain) {
        if (!this.getCookbook().getIngredients().isEmpty()) {
            System.out.println("\nGenerating ingredient data snapshot types in " + directory + "...");
        }
        for (Ingredient ingredient : this.getCookbook().getIngredients()) {
            HashMap<String, Set<String>> info = new HashMap<String, Set<String>>();
            info.put("nonPrimitiveTypes", CookbookUtils.getNonPrimitiveTypes(ingredient, this.getCookbook()));
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("ingredient", ingredient);
            data.put("options", options);
            data.put("info", info);
            String rendered = this.renderTemplate("templates/ts/ingredient-data-types.liquid", data);
            String filepath = directory + File.separator + ingredient.getName() + "Data.d.ts";
            this.writeToFile(filepath, rendered);
            System.out.println("  -> " + ingredient.getName() + "Data.d.ts");
        }
    }

    private void generateEnumTypes(String directory, Map<String, Object> options) {
        if (!this.getCookbook().getEnums().isEmpty()) {
            System.out.println("\nGenerating hook enum definitions in " + directory + "...");
        }
        for (Enum enumeration : this.getCookbook().getEnums()) {
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("enum", enumeration);
            data.put("options", options);
            String rendered = this.renderTemplate("templates/ts/enum-types.liquid", data);
            String filepath = directory + File.separator + enumeration.getName() + ".d.ts";
            this.writeToFile(filepath, rendered);
            System.out.println("  -> " + enumeration.getName() + ".d.ts");
        }
    }

    private void generateIndexTypes(String directory) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        System.out.println("\nGenerating index file: " + directory + File.separator + "index.d.ts");
        data.put("ingredients", this.getCookbook().getIngredients());
        data.put("enums", this.getCookbook().getEnums());
        String rendered = this.renderTemplate("templates/ts/hook-index-types.liquid", data);
        String filepath = directory + File.separator + "index.d.ts";
        this.writeToFile(filepath, rendered);
    }
}

