/*
 * Decompiled with CFR 0.152.
 */
package ca.derekcormier.recipe.generator;

import ca.derekcormier.recipe.cookbook.Cookbook;
import ca.derekcormier.recipe.cookbook.CookbookLoader;
import ca.derekcormier.recipe.generator.Flavour;
import ca.derekcormier.recipe.generator.Generator;
import ca.derekcormier.recipe.generator.GeneratorFactory;
import java.io.FileInputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;

public class Main {
    @Argument(index=0, usage="name of ingredient domain", metaVar="domain")
    private String domain;
    @Argument(index=1, usage="type of generation to perform; valid options: java-ingredient, java-hook, js-ingredient, js-hook, ts-ingredient, ts-hook", metaVar="flavour")
    private String flavour;
    @Argument(index=2, usage="path to the yaml cookbook definition file", metaVar="cookbook")
    private String cookbook;
    @Argument(index=3, usage="directory to output generated files", metaVar="targetDir")
    private String targetDir;
    @Option(name="--javaPackage", usage="java package for generated classes", metaVar="package")
    private String javaPackage;
    @Option(name="--ingredientPostfix", usage="string to append to ingredient names", metaVar="postfix")
    private String ingredientPostfox;
    private CmdLineParser parser;

    public static void main(String[] args) {
        new Main().doMain(args);
    }

    public void doMain(String[] args) {
        this.parser = new CmdLineParser((Object)this);
        try {
            this.parser.parseArgument(args);
        }
        catch (CmdLineException e) {
            System.err.println("could not parse arguments");
            this.printUsage();
            System.exit(1);
        }
        if (null == this.domain || null == this.flavour || null == this.cookbook || null == this.targetDir) {
            this.printUsage();
            System.exit(1);
        }
        Map<String, Object> options = this.createOptions();
        try (FileInputStream ingredients = new FileInputStream(this.cookbook);){
            Cookbook cookbook = new CookbookLoader().load(ingredients);
            Generator generator = GeneratorFactory.getGenerator(Flavour.fromAlias(this.flavour), cookbook);
            generator.generate(this.domain, this.targetDir, options);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Map<String, Object> createOptions() {
        HashMap<String, Object> options = new HashMap<String, Object>();
        if (null != this.javaPackage) {
            options.put("javaPackage", this.javaPackage);
        }
        if (null != this.ingredientPostfox) {
            options.put("ingredientPostfix", this.ingredientPostfox);
        }
        return options;
    }

    private void printUsage() {
        System.err.println("USAGE: java -jar {jarpath} [options...] arguments...");
        this.parser.printUsage((OutputStream)System.err);
    }
}

