/*
 * Decompiled with CFR 0.152.
 */
package ca.derekcormier.recipe.generator;

import ca.derekcormier.recipe.cookbook.Cookbook;
import ca.derekcormier.recipe.cookbook.CookbookUtils;
import ca.derekcormier.recipe.cookbook.Enum;
import ca.derekcormier.recipe.cookbook.Ingredient;
import ca.derekcormier.recipe.cookbook.Required;
import ca.derekcormier.recipe.generator.JavaScriptGenerator;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class JavaScriptIngredientGenerator
extends JavaScriptGenerator {
    public JavaScriptIngredientGenerator(Cookbook cookbook) {
        super(cookbook);
    }

    @Override
    public void generate(String domain, String targetDir, Map<String, Object> options) {
        String directory = this.createDirectories(targetDir);
        options.putIfAbsent("ingredientPostfix", "");
        options.putIfAbsent("runtimeLibrary", "recipe-js-runtime");
        Cookbook cookbook = this.getCookbook();
        if (!cookbook.getIngredients().isEmpty()) {
            System.out.println("Generating ingredients in " + directory + "...");
        }
        for (Ingredient ingredient : cookbook.getIngredients()) {
            HashMap<String, Object> info = new HashMap<String, Object>();
            info.put("requiredTypes", this.getRequiredTypeMapping(ingredient));
            info.put("nonPrimitiveTypes", CookbookUtils.getNonPrimitiveTypes(ingredient, cookbook));
            info.put("constantKeys", this.getConstantKeyValueArrays(ingredient).get(0));
            info.put("constantValues", this.getConstantKeyValueArrays(ingredient).get(1));
            info.put("isVararg", this.getIsVarargMap(ingredient, cookbook));
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("ingredient", ingredient);
            data.put("domain", domain);
            data.put("options", options);
            data.put("info", info);
            String rendered = this.renderTemplate("templates/js/ingredient.liquid", data);
            String filepath = directory + File.separator + ingredient.getName() + options.get("ingredientPostfix") + ".js";
            this.writeToFile(filepath, rendered);
            System.out.println("  -> " + ingredient.getName() + options.get("ingredientPostfix") + ".js");
        }
        if (!cookbook.getEnums().isEmpty()) {
            System.out.println("\nGenerating ingredient enums in " + directory + "...");
        }
        for (Enum enumeration : cookbook.getEnums()) {
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("enum", enumeration);
            data.put("options", options);
            String rendered = this.renderTemplate("templates/js/enum.liquid", data);
            String filepath = directory + File.separator + enumeration.getName() + ".js";
            this.writeToFile(filepath, rendered);
            System.out.println("  -> " + enumeration.getName() + ".js");
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        System.out.println("\nGenerating index file: " + directory + File.separator + "index.js");
        data.put("ingredients", cookbook.getIngredients());
        data.put("enums", cookbook.getEnums());
        data.put("domain", domain);
        data.put("options", options);
        String rendered = this.renderTemplate("templates/js/ingredient-index.liquid", data);
        String filepath = directory + File.separator + "index.js";
        this.writeToFile(filepath, rendered);
    }

    private Map<String, String> getRequiredTypeMapping(Ingredient ingredient) {
        HashMap<String, String> requiredTypes = new HashMap<String, String>();
        for (Required required : ingredient.getRequired()) {
            requiredTypes.put(required.getName(), required.getType());
        }
        return requiredTypes;
    }

    private Map<String, Boolean> getIsVarargMap(Ingredient ingredient, Cookbook cookbook) {
        HashMap<String, Boolean> isVararg = new HashMap<String, Boolean>();
        for (Required required : ingredient.getRequired()) {
            isVararg.put(required.getName(), CookbookUtils.parseType(required.getType(), cookbook).isVararg());
        }
        return isVararg;
    }
}

