/*
 * Decompiled with CFR 0.152.
 */
package ca.derekcormier.recipe.generator;

import ca.derekcormier.recipe.cookbook.Cookbook;
import ca.derekcormier.recipe.cookbook.CookbookUtils;
import ca.derekcormier.recipe.cookbook.Enum;
import ca.derekcormier.recipe.cookbook.Ingredient;
import ca.derekcormier.recipe.generator.JavaScriptGenerator;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class JavaScriptHookGenerator
extends JavaScriptGenerator {
    public JavaScriptHookGenerator(Cookbook cookbook) {
        super(cookbook);
    }

    @Override
    public void generate(String domain, String targetDir, Map<String, Object> options) {
        options.putIfAbsent("ingredientPostfix", "");
        options.putIfAbsent("runtimeLibrary", "recipe-js-runtime");
        String directory = this.createDirectories(targetDir);
        this.generateAbstractHooks(directory, options);
        this.generateIngredientDataSnapshots(directory, options, domain);
        this.generateEnums(directory, options);
        this.generateIndex(directory);
    }

    private void generateAbstractHooks(String directory, Map<String, Object> options) {
        if (!this.getCookbook().getIngredients().isEmpty()) {
            System.out.println("Generating ingredient hooks in " + directory + "...");
        }
        for (Ingredient ingredient : this.getCookbook().getIngredients()) {
            HashMap<String, List<String>> info = new HashMap<String, List<String>>();
            info.put("constantKeys", this.getConstantKeyValueArrays(ingredient).get(0));
            info.put("constantValues", this.getConstantKeyValueArrays(ingredient).get(1));
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("ingredient", ingredient);
            data.put("options", options);
            data.put("info", info);
            String rendered = this.renderTemplate("templates/js/hook.liquid", data);
            String filepath = directory + File.separator + "Abstract" + ingredient.getName() + "Hook.js";
            this.writeToFile(filepath, rendered);
            System.out.println("  -> Abstract" + ingredient.getName() + "Hook.js");
        }
    }

    private void generateIngredientDataSnapshots(String directory, Map<String, Object> options, String domain) {
        if (!this.getCookbook().getIngredients().isEmpty()) {
            System.out.println("\nGenerating ingredient data snapshots in " + directory + "...");
        }
        for (Ingredient ingredient : this.getCookbook().getIngredients()) {
            HashMap<String, Set<String>> info = new HashMap<String, Set<String>>();
            info.put("nonPrimitiveTypes", CookbookUtils.getNonPrimitiveTypes(ingredient, this.getCookbook()));
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("ingredient", ingredient);
            data.put("options", options);
            data.put("domain", domain);
            data.put("info", info);
            String rendered = this.renderTemplate("templates/js/ingredient-data.liquid", data);
            String filepath = directory + File.separator + ingredient.getName() + "Data.js";
            this.writeToFile(filepath, rendered);
            System.out.println("  -> " + ingredient.getName() + "Data.js");
        }
    }

    private void generateEnums(String directory, Map<String, Object> options) {
        Cookbook cookbook = this.getCookbook();
        if (!cookbook.getEnums().isEmpty()) {
            System.out.println("\nGenerating hook enums in " + directory + "...");
        }
        for (Enum enumeration : cookbook.getEnums()) {
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("enum", enumeration);
            data.put("options", options);
            String rendered = this.renderTemplate("templates/js/enum.liquid", data);
            String filepath = directory + File.separator + enumeration.getName() + ".js";
            this.writeToFile(filepath, rendered);
            System.out.println("  -> " + enumeration.getName() + ".js");
        }
    }

    private void generateIndex(String directory) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        System.out.println("\nGenerating index file: " + directory + File.separator + "index.js");
        data.put("ingredients", this.getCookbook().getIngredients());
        data.put("enums", this.getCookbook().getEnums());
        String rendered = this.renderTemplate("templates/js/hook-index.liquid", data);
        String filepath = directory + File.separator + "index.js";
        this.writeToFile(filepath, rendered);
    }
}

