/*
 * Decompiled with CFR 0.152.
 */
package ca.derekcormier.recipe.generator;

import ca.derekcormier.recipe.cookbook.Cookbook;
import ca.derekcormier.recipe.cookbook.Enum;
import ca.derekcormier.recipe.cookbook.Ingredient;
import ca.derekcormier.recipe.generator.JavaGenerator;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JavaHookGenerator
extends JavaGenerator {
    public JavaHookGenerator(Cookbook cookbook) {
        super(cookbook);
    }

    @Override
    public void generate(String domain, String targetDir, Map<String, Object> options) {
        String filepath;
        String rendered;
        HashMap<String, Object> data;
        String javaPackage;
        if (!options.containsKey("javaPackage")) {
            options.put("javaPackage", "");
        }
        if (!(javaPackage = (String)options.get("javaPackage")).isEmpty()) {
            targetDir = targetDir + "/" + String.join((CharSequence)"/", Arrays.asList(javaPackage.split("\\.")));
        }
        String directory = this.createDirectories(targetDir);
        Cookbook cookbook = this.getCookbook();
        if (!cookbook.getIngredients().isEmpty()) {
            System.out.println("Generating ingredient hooks in " + directory + "...");
        }
        for (Ingredient ingredient : cookbook.getIngredients()) {
            HashMap<String, List<String>> info = new HashMap<String, List<String>>();
            info.put("constantKeys", this.getConstantKeyValueArrays(ingredient).get(0));
            info.put("constantValues", this.getConstantKeyValueArrays(ingredient).get(1));
            HashMap<String, Object> data2 = new HashMap<String, Object>();
            data2.put("ingredient", ingredient);
            data2.put("options", options);
            data2.put("info", info);
            String rendered2 = this.renderTemplate("templates/java/hook.liquid", data2);
            String filepath2 = directory + File.separator + "Abstract" + ingredient.getName() + "Hook.java";
            this.writeToFile(filepath2, rendered2);
            System.out.println("  -> Abstract" + ingredient.getName() + "Hook.java");
        }
        if (!cookbook.getIngredients().isEmpty()) {
            System.out.println("\nGenerating ingredient data snapshots in " + directory + "...");
        }
        for (Ingredient ingredient : cookbook.getIngredients()) {
            data = new HashMap<String, Object>();
            data.put("ingredient", ingredient);
            data.put("options", options);
            data.put("domain", domain);
            rendered = this.renderTemplate("templates/java/ingredient-data.liquid", data);
            filepath = directory + File.separator + ingredient.getName() + "Data.java";
            this.writeToFile(filepath, rendered);
            System.out.println("  -> " + ingredient.getName() + "Data.java");
        }
        if (!cookbook.getEnums().isEmpty()) {
            System.out.println("\nGenerating hook enums in " + directory + "...");
        }
        for (Enum enumeration : cookbook.getEnums()) {
            data = new HashMap();
            data.put("enum", enumeration);
            data.put("options", options);
            rendered = this.renderTemplate("templates/java/enum.liquid", data);
            filepath = directory + File.separator + enumeration.getName() + ".java";
            this.writeToFile(filepath, rendered);
            System.out.println("  -> " + enumeration.getName() + ".java");
        }
    }
}

