/*
 * Decompiled with CFR 0.152.
 */
package ca.derekcormier.recipe.generator;

import ca.derekcormier.recipe.cookbook.Cookbook;
import ca.derekcormier.recipe.generator.Generator;
import ca.derekcormier.recipe.generator.filter.JavaGetterFilter;
import ca.derekcormier.recipe.generator.filter.JavaIdentifierFilter;
import ca.derekcormier.recipe.generator.filter.JavaParamFilter;
import ca.derekcormier.recipe.generator.filter.JavaTypeFilter;
import ca.derekcormier.recipe.generator.filter.JavaValueFilter;
import com.google.googlejavaformat.java.Formatter;
import com.google.googlejavaformat.java.FormatterException;
import com.google.googlejavaformat.java.JavaFormatterOptions;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import liqp.filters.Filter;

public abstract class JavaGenerator
extends Generator {
    public JavaGenerator(Cookbook cookbook) {
        super(cookbook);
    }

    @Override
    protected List<Filter> getTemplateFilters() {
        JavaTypeFilter javaTypeFilter = new JavaTypeFilter(this.getCookbook());
        JavaIdentifierFilter javaIdentifierFilter = new JavaIdentifierFilter();
        return Arrays.asList(new Filter[]{javaTypeFilter, javaIdentifierFilter, new JavaParamFilter(this.getCookbook(), javaTypeFilter, javaIdentifierFilter), new JavaValueFilter(this.getCookbook()), new JavaGetterFilter()});
    }

    @Override
    protected String renderTemplate(String templatePath, Map<String, Object> data) {
        String generatedJava = super.renderTemplate(templatePath, data);
        Formatter formatter = new Formatter(JavaFormatterOptions.builder().style(JavaFormatterOptions.Style.AOSP).build());
        try {
            return formatter.formatSource(generatedJava);
        }
        catch (FormatterException e) {
            throw new RuntimeException(e);
        }
    }
}

