/*
 * Decompiled with CFR 0.152.
 */
package ca.derekcormier.recipe.cookbook;

import ca.derekcormier.recipe.cookbook.Cookbook;
import ca.derekcormier.recipe.cookbook.Enum;
import ca.derekcormier.recipe.cookbook.Ingredient;
import ca.derekcormier.recipe.cookbook.Optional;
import ca.derekcormier.recipe.cookbook.Param;
import ca.derekcormier.recipe.cookbook.Primitive;
import ca.derekcormier.recipe.cookbook.Required;
import ca.derekcormier.recipe.cookbook.type.ArrayType;
import ca.derekcormier.recipe.cookbook.type.EnumType;
import ca.derekcormier.recipe.cookbook.type.FlagType;
import ca.derekcormier.recipe.cookbook.type.ParamType;
import ca.derekcormier.recipe.cookbook.type.PrimitiveType;
import ca.derekcormier.recipe.cookbook.type.Type;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;

public class CookbookUtils {
    public static boolean isPrimitiveType(String type) {
        try {
            Primitive.fromAlias(type);
            return true;
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    public static boolean isFlagType(String flag) {
        return "flag".equals(flag);
    }

    public static boolean isKnownType(Cookbook cookbook, String type) {
        return CookbookUtils.isPrimitiveType(type) || CookbookUtils.isFlagType(type) || CookbookUtils.isEnumType(cookbook, type);
    }

    public static boolean isEnumType(Cookbook cookbook, String name) {
        return cookbook.getEnums().stream().anyMatch(e -> e.getName().equals(name));
    }

    public static boolean enumHasValue(Cookbook cookbook, String enumName, String value) {
        return CookbookUtils.isEnumType(cookbook, enumName) && ((Enum)cookbook.getEnums().stream().filter(e -> e.getName().equals(enumName)).collect(Collectors.toList()).get(0)).getValues().contains(value);
    }

    public static boolean isPrimitiveType(Type type) {
        return type instanceof PrimitiveType || type instanceof ArrayType && CookbookUtils.isPrimitiveType(((ArrayType)type).getBaseType());
    }

    public static boolean isNonPrimitive(String type, Cookbook cookbook) {
        Type t = CookbookUtils.parseType(type, cookbook).getType();
        return !CookbookUtils.isPrimitiveType(t) && !(t instanceof FlagType);
    }

    public static Set<String> getNonPrimitiveTypes(Ingredient ingredient, Cookbook cookbook) {
        HashSet<String> types = new HashSet<String>();
        for (Required required : ingredient.getRequired()) {
            if (!CookbookUtils.isNonPrimitive(required.getType(), cookbook)) continue;
            types.add(CookbookUtils.getBaseType(required.getType(), cookbook));
        }
        for (Optional optional : ingredient.getOptionals()) {
            if (!optional.isCompound() && CookbookUtils.isNonPrimitive(optional.getType(), cookbook)) {
                types.add(CookbookUtils.getBaseType(optional.getType(), cookbook));
                continue;
            }
            if (!optional.isCompound()) continue;
            for (Param param : optional.getParams()) {
                if (!CookbookUtils.isNonPrimitive(param.getType(), cookbook)) continue;
                types.add(CookbookUtils.getBaseType(param.getType(), cookbook));
            }
        }
        return types;
    }

    public static String getBaseType(String type, Cookbook cookbook) {
        ParamType paramType = CookbookUtils.parseType(type, cookbook);
        if (paramType.getType() instanceof ArrayType) {
            return CookbookUtils.getBaseType(((ArrayType)paramType.getType()).getBaseType().name(), cookbook);
        }
        return paramType.getType().name();
    }

    public static ParamType parseType(String type, Cookbook cookbook) {
        if (type.endsWith("...")) {
            Type parsed = CookbookUtils._parseType(type.substring(0, type.length() - 3), cookbook);
            if (parsed instanceof FlagType) {
                throw new RuntimeException("flag types cannot be varargs");
            }
            return new ParamType(parsed, true);
        }
        return new ParamType(CookbookUtils._parseType(type, cookbook), false);
    }

    private static Type _parseType(String type, Cookbook cookbook) {
        if (CookbookUtils.isPrimitiveType(type)) {
            return new PrimitiveType(Primitive.fromAlias(type));
        }
        if (CookbookUtils.isFlagType(type)) {
            return new FlagType();
        }
        if (CookbookUtils.isEnumType(cookbook, type)) {
            return new EnumType(type);
        }
        if (type.endsWith("[]")) {
            return new ArrayType(CookbookUtils._parseType(type.substring(0, type.length() - 2), cookbook));
        }
        throw new RuntimeException("unknown type '" + type + "'");
    }
}

