/*
 * Decompiled with CFR 0.152.
 */
package ca.derekcormier.recipe.generator.filter;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import liqp.filters.Filter;

public class JavaGetterFilter
extends Filter {
    private static String[] objectMethodNames = Arrays.stream(Object.class.getMethods()).map(m -> m.getName()).collect(Collectors.toList()).toArray(new String[0]);

    public JavaGetterFilter() {
        super("javagetter");
    }

    public Object apply(Object value, Object ... params) {
        Map param = (Map)value;
        String name = (String)param.get("name");
        String type = (String)param.get("type");
        boolean compound = param.containsKey("compound") && (Boolean)param.get("compound") != false;
        name = name.substring(0, 1).toUpperCase() + name.substring(1);
        value = !compound && (type.equals("boolean") || type.equals("flag")) ? "is" + name : "get" + name;
        if (Arrays.binarySearch(objectMethodNames, value) >= 0) {
            value = value + "_";
        }
        return value;
    }

    static {
        Arrays.sort(objectMethodNames);
    }
}

