/*
 * Decompiled with CFR 0.152.
 */
package ca.derekcormier.recipe.generator;

import ca.derekcormier.recipe.cookbook.Cookbook;
import ca.derekcormier.recipe.cookbook.CookbookUtils;
import ca.derekcormier.recipe.cookbook.Enum;
import ca.derekcormier.recipe.cookbook.Ingredient;
import ca.derekcormier.recipe.generator.JavaScriptIngredientGenerator;
import ca.derekcormier.recipe.generator.TypeScriptCookbookGenerator;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class TypeScriptIngredientGenerator
extends TypeScriptCookbookGenerator {
    public TypeScriptIngredientGenerator(Cookbook cookbook) {
        super(cookbook);
    }

    @Override
    public void generate(String domain, String targetDir, Map<String, Object> options) {
        String directory = this.createDirectories(targetDir);
        options.putIfAbsent("ingredientPostfix", "");
        options.putIfAbsent("runtimeLibrary", "recipe-ts-runtime");
        JavaScriptIngredientGenerator jsGenerator = new JavaScriptIngredientGenerator(this.getCookbook());
        jsGenerator.generate(domain, targetDir, options);
        Cookbook cookbook = this.getCookbook();
        if (!cookbook.getIngredients().isEmpty()) {
            System.out.println("\nGenerating ingredient definitions in " + directory + "...");
        }
        for (Ingredient ingredient : cookbook.getIngredients()) {
            HashMap<String, Collection<String>> info = new HashMap<String, Collection<String>>();
            info.put("nonPrimitiveTypes", CookbookUtils.getNonPrimitiveTypes(ingredient, cookbook));
            info.put("constantKeys", this.getConstantKeyValueArrays(ingredient).get(0));
            info.put("constantValues", this.getConstantKeyValueArrays(ingredient).get(1));
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("ingredient", ingredient);
            data.put("domain", domain);
            data.put("options", options);
            data.put("info", info);
            String rendered = this.renderTemplate("templates/ts/ingredient-types.liquid", data);
            String filepath = directory + File.separator + ingredient.getName() + options.get("ingredientPostfix") + ".d.ts";
            this.writeToFile(filepath, rendered);
            System.out.println("  -> " + ingredient.getName() + options.get("ingredientPostfix") + ".d.ts");
        }
        if (!cookbook.getEnums().isEmpty()) {
            System.out.println("\nGenerating ingredient enum definitions in " + directory + "...");
        }
        for (Enum enumeration : cookbook.getEnums()) {
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("enum", enumeration);
            data.put("options", options);
            String rendered = this.renderTemplate("templates/ts/enum-types.liquid", data);
            String filepath = directory + File.separator + enumeration.getName() + ".d.ts";
            this.writeToFile(filepath, rendered);
            System.out.println("  -> " + enumeration.getName() + ".d.ts");
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        System.out.println("\nGenerating index definition file: " + directory + File.separator + "index.d.ts");
        data.put("ingredients", cookbook.getIngredients());
        data.put("enums", cookbook.getEnums());
        data.put("domain", domain);
        data.put("options", options);
        String rendered = this.renderTemplate("templates/ts/ingredient-index-types.liquid", data);
        String filepath = directory + File.separator + "index.d.ts";
        this.writeToFile(filepath, rendered);
    }
}

