/*
 * Decompiled with CFR 0.152.
 */
package ca.derekcormier.recipe.generator;

import ca.derekcormier.recipe.cookbook.Cookbook;
import ca.derekcormier.recipe.cookbook.Enum;
import ca.derekcormier.recipe.cookbook.Ingredient;
import ca.derekcormier.recipe.generator.JavaCookbookGenerator;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JavaIngredientGenerator
extends JavaCookbookGenerator {
    public JavaIngredientGenerator(Cookbook cookbook) {
        super(cookbook);
    }

    @Override
    public void generate(String domain, String targetDir, Map<String, Object> options) {
        if (!options.containsKey("javaPackage")) {
            options.put("javaPackage", "");
        }
        options.putIfAbsent("ingredientPostfix", "");
        String javaPackage = (String)options.get("javaPackage");
        if (!javaPackage.isEmpty()) {
            targetDir = targetDir + "/" + String.join((CharSequence)"/", Arrays.asList(javaPackage.split("\\.")));
        }
        String directory = this.createDirectories(targetDir);
        Cookbook cookbook = this.getCookbook();
        if (!cookbook.getIngredients().isEmpty()) {
            System.out.println("Generating ingredients in " + directory + "...");
        }
        for (Ingredient ingredient : cookbook.getIngredients()) {
            HashMap<String, List<String>> info = new HashMap<String, List<String>>();
            info.put("constantKeys", this.getConstantKeyValueArrays(ingredient).get(0));
            info.put("constantValues", this.getConstantKeyValueArrays(ingredient).get(1));
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("ingredient", ingredient);
            data.put("domain", domain);
            data.put("options", options);
            data.put("info", info);
            String rendered = this.renderTemplate("templates/java/ingredient.liquid", data);
            String filepath = directory + File.separator + ingredient.getName() + options.get("ingredientPostfix") + ".java";
            this.writeToFile(filepath, rendered);
            System.out.println("  -> " + ingredient.getName() + options.get("ingredientPostfix") + ".java");
        }
        if (!cookbook.getEnums().isEmpty()) {
            System.out.println("\nGenerating ingredient enums in " + directory + "...");
        }
        for (Enum enumeration : cookbook.getEnums()) {
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("enum", enumeration);
            data.put("options", options);
            String rendered = this.renderTemplate("templates/java/enum.liquid", data);
            String filepath = directory + File.separator + enumeration.getName() + ".java";
            this.writeToFile(filepath, rendered);
            System.out.println("  -> " + enumeration.getName() + ".java");
        }
    }
}

