/*
 * Decompiled with CFR 0.152.
 */
package ca.derekcormier.recipe.generator;

import ca.derekcormier.recipe.cookbook.Cookbook;
import ca.derekcormier.recipe.cookbook.CookbookUtils;
import ca.derekcormier.recipe.cookbook.Enum;
import ca.derekcormier.recipe.cookbook.Ingredient;
import ca.derekcormier.recipe.cookbook.Optional;
import ca.derekcormier.recipe.cookbook.Param;
import ca.derekcormier.recipe.cookbook.Required;
import ca.derekcormier.recipe.cookbook.type.ArrayType;
import ca.derekcormier.recipe.cookbook.type.FlagType;
import ca.derekcormier.recipe.cookbook.type.ParamType;
import ca.derekcormier.recipe.cookbook.type.Type;
import ca.derekcormier.recipe.generator.CookbookGenerator;
import ca.derekcormier.recipe.generator.filter.JsParamFilter;
import ca.derekcormier.recipe.generator.filter.TsParamFilter;
import ca.derekcormier.recipe.generator.filter.TsTypeFilter;
import ca.derekcormier.recipe.generator.filter.TsValueFilter;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import liqp.filters.Filter;

public class TypescriptIngredientGenerator
extends CookbookGenerator {
    @Override
    public void generate(String domain, Cookbook cookbook, String targetDir, Map<String, Object> options) {
        String filepath;
        String rendered;
        HashMap<String, Object> data;
        String filepath2;
        String rendered2;
        HashMap<String, Object> data2;
        HashMap<String, Object> info;
        this.registerFilters(cookbook);
        String directory = this.createDirectories(targetDir);
        options.putIfAbsent("ingredientPostfix", "");
        if (!cookbook.getIngredients().isEmpty()) {
            System.out.println("Generating ingredients in " + directory + "...");
        }
        for (Ingredient ingredient : cookbook.getIngredients()) {
            info = new HashMap<String, Object>();
            info.put("requiredTypes", this.getRequiredTypeMapping(ingredient));
            info.put("nonPrimitiveTypes", this.getNonPrimitiveTypes(ingredient, cookbook));
            info.put("constantKeys", this.getConstantKeyValueArrays(ingredient).get(0));
            info.put("constantValues", this.getConstantKeyValueArrays(ingredient).get(1));
            info.put("isVararg", this.getIsVarargMap(ingredient, cookbook));
            data2 = new HashMap();
            data2.put("ingredient", ingredient);
            data2.put("domain", domain);
            data2.put("options", options);
            data2.put("info", info);
            rendered2 = this.renderTemplate("templates/ts/ingredient.liquid", data2);
            filepath2 = directory + File.separator + ingredient.getName() + options.get("ingredientPostfix") + ".js";
            this.writeToFile(filepath2, rendered2);
            System.out.println("  -> " + ingredient.getName() + options.get("ingredientPostfix") + ".js");
        }
        if (!cookbook.getIngredients().isEmpty()) {
            System.out.println("\nGenerating ingredient definitions in " + directory + "...");
        }
        for (Ingredient ingredient : cookbook.getIngredients()) {
            info = new HashMap();
            info.put("nonPrimitiveTypes", this.getNonPrimitiveTypes(ingredient, cookbook));
            info.put("constantKeys", this.getConstantKeyValueArrays(ingredient).get(0));
            info.put("constantValues", this.getConstantKeyValueArrays(ingredient).get(1));
            data2 = new HashMap<String, Object>();
            data2.put("ingredient", ingredient);
            data2.put("domain", domain);
            data2.put("options", options);
            data2.put("info", info);
            rendered2 = this.renderTemplate("templates/ts/ingredient-types.liquid", data2);
            filepath2 = directory + File.separator + ingredient.getName() + options.get("ingredientPostfix") + ".d.ts";
            this.writeToFile(filepath2, rendered2);
            System.out.println("  -> " + ingredient.getName() + options.get("ingredientPostfix") + ".d.ts");
        }
        if (!cookbook.getEnums().isEmpty()) {
            System.out.println("\nGenerating ingredient enums in " + directory + "...");
        }
        for (Enum enumeration : cookbook.getEnums()) {
            data = new HashMap<String, Object>();
            data.put("enum", enumeration);
            data.put("options", options);
            rendered = this.renderTemplate("templates/ts/enum.liquid", data);
            filepath = directory + File.separator + enumeration.getName() + ".js";
            this.writeToFile(filepath, rendered);
            System.out.println("  -> " + enumeration.getName() + ".js");
        }
        if (!cookbook.getEnums().isEmpty()) {
            System.out.println("\nGenerating ingredient enum definitions in " + directory + "...");
        }
        for (Enum enumeration : cookbook.getEnums()) {
            data = new HashMap();
            data.put("enum", enumeration);
            data.put("options", options);
            rendered = this.renderTemplate("templates/ts/enum-types.liquid", data);
            filepath = directory + File.separator + enumeration.getName() + ".d.ts";
            this.writeToFile(filepath, rendered);
            System.out.println("  -> " + enumeration.getName() + ".d.ts");
        }
        HashMap<String, Object> data3 = new HashMap<String, Object>();
        System.out.println("\nGenerating index file: " + directory + File.separator + "index.js");
        data3.put("ingredients", cookbook.getIngredients());
        data3.put("enums", cookbook.getEnums());
        data3.put("domain", domain);
        data3.put("options", options);
        String rendered3 = this.renderTemplate("templates/ts/ingredient-index.liquid", data3);
        String filepath3 = directory + File.separator + "index.js";
        this.writeToFile(filepath3, rendered3);
        System.out.println("\nGenerating index definition file: " + directory + File.separator + "index.d.ts");
        data3 = new HashMap();
        data3.put("ingredients", cookbook.getIngredients());
        data3.put("enums", cookbook.getEnums());
        data3.put("domain", domain);
        data3.put("options", options);
        rendered3 = this.renderTemplate("templates/ts/ingredient-index-types.liquid", data3);
        filepath3 = directory + File.separator + "index.d.ts";
        this.writeToFile(filepath3, rendered3);
    }

    private void registerFilters(Cookbook cookbook) {
        TsTypeFilter tsTypeFilter = new TsTypeFilter(cookbook);
        Filter.registerFilter((Filter)tsTypeFilter);
        Filter.registerFilter((Filter)new TsParamFilter(cookbook, tsTypeFilter));
        Filter.registerFilter((Filter)new JsParamFilter(cookbook));
        Filter.registerFilter((Filter)new TsValueFilter(cookbook));
    }

    private Map<String, String> getRequiredTypeMapping(Ingredient ingredient) {
        HashMap<String, String> requiredTypes = new HashMap<String, String>();
        for (Required required : ingredient.getRequired()) {
            requiredTypes.put(required.getName(), required.getType());
        }
        return requiredTypes;
    }

    private Map<String, Boolean> getIsVarargMap(Ingredient ingredient, Cookbook cookbook) {
        HashMap<String, Boolean> isVararg = new HashMap<String, Boolean>();
        for (Required required : ingredient.getRequired()) {
            isVararg.put(required.getName(), CookbookUtils.parseType(required.getType(), cookbook).isVararg());
        }
        return isVararg;
    }

    private Set<String> getNonPrimitiveTypes(Ingredient ingredient, Cookbook cookbook) {
        HashSet<String> types = new HashSet<String>();
        for (Required required : ingredient.getRequired()) {
            if (!this.isNonPrimitive(required.getType(), cookbook)) continue;
            types.add(this.getBaseType(required.getType(), cookbook));
        }
        for (Optional optional : ingredient.getOptionals()) {
            if (!optional.isCompound() && this.isNonPrimitive(optional.getType(), cookbook)) {
                types.add(this.getBaseType(optional.getType(), cookbook));
                continue;
            }
            if (!optional.isCompound()) continue;
            for (Param param : optional.getParams()) {
                if (!this.isNonPrimitive(param.getType(), cookbook)) continue;
                types.add(this.getBaseType(param.getType(), cookbook));
            }
        }
        return types;
    }

    private boolean isNonPrimitive(String type, Cookbook cookbook) {
        Type t = CookbookUtils.parseType(type, cookbook).getType();
        return !CookbookUtils.isPrimitiveType(t) && !(t instanceof FlagType);
    }

    private String getBaseType(String type, Cookbook cookbook) {
        ParamType paramType = CookbookUtils.parseType(type, cookbook);
        if (paramType.getType() instanceof ArrayType) {
            return this.getBaseType(((ArrayType)paramType.getType()).getBaseType().name(), cookbook);
        }
        return paramType.getType().name();
    }
}

