/*
 * Decompiled with CFR 0.152.
 */
package ca.derekcormier.recipe.generator;

import ca.derekcormier.recipe.cookbook.Cookbook;
import ca.derekcormier.recipe.cookbook.CookbookUtils;
import ca.derekcormier.recipe.cookbook.Primitive;
import ca.derekcormier.recipe.cookbook.type.ArrayType;
import ca.derekcormier.recipe.cookbook.type.EnumType;
import ca.derekcormier.recipe.cookbook.type.FlagType;
import ca.derekcormier.recipe.cookbook.type.ParamType;
import ca.derekcormier.recipe.cookbook.type.PrimitiveType;
import ca.derekcormier.recipe.cookbook.type.Type;
import java.util.Map;
import liqp.filters.Filter;

public class TypescriptFilters {
    public static Filter createTsTypeFilter(final Cookbook cookbook) {
        return new Filter("tstype"){

            public Object apply(Object value, Object ... params) {
                ParamType type = CookbookUtils.parseType(super.asString(value), cookbook);
                return TypescriptFilters.toTsType(type);
            }
        };
    }

    public static Filter createTsParamFilter(final Cookbook cookbook) {
        return new Filter("tsparam"){

            public Object apply(Object value, Object ... params) {
                Map param = (Map)value;
                String name = (String)param.get("name");
                ParamType type = CookbookUtils.parseType((String)param.get("type"), cookbook);
                return (type.isVararg() ? "..." : "") + name + ": " + TypescriptFilters.toTsType(type);
            }
        };
    }

    public static Filter createJsParamFilter(final Cookbook cookbook) {
        return new Filter("jsparam"){

            public Object apply(Object value, Object ... params) {
                Map param = (Map)value;
                String name = (String)param.get("name");
                ParamType type = CookbookUtils.parseType((String)param.get("type"), cookbook);
                return (type.isVararg() ? "..." : "") + name;
            }
        };
    }

    public static Filter createTsValueFilter(final Cookbook cookbook) {
        return new Filter("tsvalue"){

            public Object apply(Object value, Object ... params) {
                String strType = super.asString(params[0]);
                if (CookbookUtils.isKnownType(cookbook, strType)) {
                    if (CookbookUtils.isPrimitiveType(strType)) {
                        Primitive type = Primitive.fromAlias(strType);
                        switch (type) {
                            case BOOLEAN: {
                                return super.asString(value);
                            }
                            case INTEGER: {
                                return super.asString(value);
                            }
                            case FLOAT: {
                                return super.asString(value);
                            }
                            case STRING: {
                                return value == null ? "null" : "\"" + super.asString(value).replace("\"", "\\\"") + "\"";
                            }
                        }
                        throw new RuntimeException("unknown data type '" + strType + "'");
                    }
                    if (CookbookUtils.isEnumType(cookbook, strType)) {
                        if (CookbookUtils.enumHasValue(cookbook, strType, super.asString(value))) {
                            return strType + "." + super.asString(value);
                        }
                        throw new RuntimeException("value '" + super.asString(value) + "' is not a member of enum '" + strType + "'");
                    }
                }
                throw new RuntimeException("unknown data type '" + super.asString(value) + "'");
            }
        };
    }

    private static String toTsType(ParamType type) {
        boolean isWrapped = type.isVararg() && type.getType() instanceof PrimitiveType && ((PrimitiveType)type.getType()).getPrimitive() == Primitive.STRING;
        return (isWrapped ? "(" : "") + TypescriptFilters._toTsType(type.getType()) + (isWrapped ? ")" : "") + (type.isVararg() ? "[]" : "");
    }

    private static String _toTsType(Type type) {
        if (type instanceof PrimitiveType) {
            switch (((PrimitiveType)type).getPrimitive()) {
                case BOOLEAN: {
                    return "boolean";
                }
                case INTEGER: {
                    return "number";
                }
                case FLOAT: {
                    return "number";
                }
                case STRING: {
                    return "string | null";
                }
            }
            throw new RuntimeException("unknown type");
        }
        if (type instanceof FlagType) {
            return "boolean";
        }
        if (type instanceof EnumType) {
            return ((EnumType)type).getName();
        }
        if (type instanceof ArrayType) {
            boolean isWrapped = ((ArrayType)type).getBaseType() instanceof PrimitiveType && ((PrimitiveType)((ArrayType)type).getBaseType()).getPrimitive() == Primitive.STRING;
            return (isWrapped ? "(" : "") + TypescriptFilters._toTsType(((ArrayType)type).getBaseType()) + (isWrapped ? ")" : "") + "[]";
        }
        throw new RuntimeException("unknown type");
    }
}

