/*
 * Decompiled with CFR 0.152.
 */
package ca.derekcormier.recipe.cookbook;

import ca.derekcormier.recipe.cookbook.Cookbook;
import ca.derekcormier.recipe.cookbook.CookbookUtils;
import ca.derekcormier.recipe.cookbook.Enum;
import ca.derekcormier.recipe.cookbook.Ingredient;
import ca.derekcormier.recipe.cookbook.Initializer;
import ca.derekcormier.recipe.cookbook.Optional;
import ca.derekcormier.recipe.cookbook.Param;
import ca.derekcormier.recipe.cookbook.Required;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.SourceVersion;

public class CookbookLoader {
    public Cookbook load(InputStream ingredients) {
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        Cookbook cookbook = null;
        try {
            cookbook = (Cookbook)mapper.readValue(ingredients, Cookbook.class);
        }
        catch (IOException e) {
            throw new RuntimeException("could not load recipe cookbook from input stream", e);
        }
        this.validate(cookbook);
        return cookbook;
    }

    private void validate(Cookbook cookbook) {
        this.validateIngredients(cookbook);
        this.validateEnums(cookbook);
    }

    private void validateIngredients(Cookbook cookbook) {
        this.validateNoDuplicateIngredientNames(cookbook);
        this.validateNoDuplicateFieldNames(cookbook);
        this.validateParamTypes(cookbook);
        this.validateInitializersContainRequiredFields(cookbook);
        this.validateInitializerSignaturesUnique(cookbook);
        this.validateRequiredHaveDefaultOrAppearInAllInitializers(cookbook);
        this.validateVaragParamsAppearLastInParamLists(cookbook);
        this.validateConstantNames(cookbook);
        this.validateNoDuplicateConstantNames(cookbook);
    }

    private void validateEnums(Cookbook cookbook) {
        this.validateNoDuplicateEnumNames(cookbook);
        this.validateNoEmptyEnumValues(cookbook);
        this.validateNoDuplicateEnumValues(cookbook);
    }

    private void validateInitializersContainRequiredFields(Cookbook cookbook) {
        for (Ingredient ingredient : cookbook.getIngredients()) {
            Set requiredParams = ingredient.getRequired().stream().map(r -> r.getName()).collect(Collectors.toSet());
            for (Initializer initializer : ingredient.getInitializers()) {
                for (String param : initializer.getParams()) {
                    if (requiredParams.contains(param)) continue;
                    throw new RuntimeException("initializer contains undeclared param '" + param + "'");
                }
            }
        }
    }

    private void validateNoDuplicateIngredientNames(Cookbook cookbook) {
        if (cookbook.getIngredients().stream().map(Ingredient::getName).distinct().count() != (long)cookbook.getIngredients().size()) {
            throw new RuntimeException("found two or more ingredients with the same name");
        }
    }

    private void validateParamTypes(Cookbook cookbook) {
        ArrayList types = new ArrayList();
        for (Ingredient ingredient : cookbook.getIngredients()) {
            types.addAll(ingredient.getRequired().stream().map(Required::getType).collect(Collectors.toList()));
            types.addAll(ingredient.getOptionals().stream().filter(o -> !o.isCompound()).map(Optional::getType).collect(Collectors.toList()));
            types.addAll(ingredient.getOptionals().stream().filter(Optional::isCompound).flatMap(o -> o.getParams().stream()).map(Param::getType).collect(Collectors.toList()));
        }
        for (String type : types) {
            CookbookUtils.parseType(type, cookbook);
        }
    }

    private void validateNoDuplicateFieldNames(Cookbook cookbook) {
        for (Ingredient ingredient : cookbook.getIngredients()) {
            HashSet names = new HashSet();
            names.addAll(ingredient.getRequired().stream().map(Required::getName).collect(Collectors.toSet()));
            names.addAll(ingredient.getOptionals().stream().map(Optional::getName).collect(Collectors.toSet()));
            if (names.size() == ingredient.getRequired().size() + ingredient.getOptionals().size()) continue;
            throw new RuntimeException("detected duplicate field names for ingredient '" + ingredient.getName() + "'");
        }
    }

    private void validateInitializerSignaturesUnique(Cookbook cookbook) {
        for (Ingredient ingredient : cookbook.getIngredients()) {
            Map<String, String> requiredParams = ingredient.getRequired().stream().collect(Collectors.toMap(Required::getName, Required::getType));
            ArrayList signatures = new ArrayList();
            for (Initializer initializer : ingredient.getInitializers()) {
                List params = initializer.getParams().stream().map(requiredParams::get).collect(Collectors.toList());
                signatures.add(params);
            }
            if (signatures.stream().distinct().count() == (long)signatures.size()) continue;
            throw new RuntimeException("initializer signatures for ingredient '" + ingredient.getName() + "' are ambiguous");
        }
    }

    private void validateRequiredHaveDefaultOrAppearInAllInitializers(Cookbook cookbook) {
        for (Ingredient ingredient : cookbook.getIngredients()) {
            for (Required required : ingredient.getRequired()) {
                if (required.hasDefault() || !ingredient.getInitializers().isEmpty() && ingredient.getInitializers().stream().allMatch(i -> i.getParams().contains(required.getName()))) continue;
                throw new RuntimeException("required '" + required.getName() + "' must either have a default or appear in all initializers");
            }
        }
    }

    private void validateVaragParamsAppearLastInParamLists(Cookbook cookbook) {
        for (Ingredient ingredient : cookbook.getIngredients()) {
            int i;
            Set requiredVarargParams = ingredient.getRequired().stream().filter(r -> CookbookUtils.parseType(r.getType(), cookbook).isVararg()).map(Required::getName).collect(Collectors.toSet());
            for (Initializer initializer : ingredient.getInitializers()) {
                for (i = 0; i < initializer.getParams().size() - 1; ++i) {
                    if (!requiredVarargParams.contains(initializer.getParams().get(i))) continue;
                    throw new RuntimeException("vararg param can only be last param in initializer");
                }
            }
            for (Optional optional : ingredient.getOptionals()) {
                if (!optional.isCompound()) continue;
                for (i = 0; i < optional.getParams().size() - 1; ++i) {
                    if (!CookbookUtils.parseType(optional.getParams().get(i).getType(), cookbook).isVararg()) continue;
                    throw new RuntimeException("vararg param can only be last param in compound optional");
                }
            }
        }
    }

    private void validateConstantNames(Cookbook cookbook) {
        for (Ingredient ingredient : cookbook.getIngredients()) {
            for (String constant : ingredient.getConstants().keySet()) {
                if (constant != null && !constant.equals("") && SourceVersion.isName(constant)) continue;
                throw new RuntimeException("ingredient '" + ingredient.getName() + "' has invalid constant name " + constant);
            }
        }
    }

    private void validateNoDuplicateConstantNames(Cookbook cookbook) {
        for (Ingredient ingredient : cookbook.getIngredients()) {
            HashSet<String> used = new HashSet<String>();
            for (String constant : ingredient.getConstants().keySet()) {
                if (used.contains(constant)) {
                    throw new RuntimeException("ingredient '" + ingredient.getName() + "' has duplicate key constant '" + constant + "'");
                }
                used.add(constant);
            }
        }
    }

    private void validateNoDuplicateEnumNames(Cookbook cookbook) {
        Set enumNames = cookbook.getEnums().stream().map(Enum::getName).collect(Collectors.toSet());
        if (enumNames.size() != cookbook.getEnums().size()) {
            throw new RuntimeException("found duplicate enum names");
        }
    }

    private void validateNoEmptyEnumValues(Cookbook cookbook) {
        if (cookbook.getEnums().stream().anyMatch(e -> e.getValues().isEmpty())) {
            throw new RuntimeException("found enum with no values");
        }
    }

    private void validateNoDuplicateEnumValues(Cookbook cookbook) {
        for (Enum e : cookbook.getEnums()) {
            if (e.getValues().stream().distinct().count() == (long)e.getValues().size()) continue;
            throw new RuntimeException("enum '" + e.getName() + "' has duplicate values");
        }
    }
}

