/*
 * Decompiled with CFR 0.152.
 */
package ca.derekcormier.recipe.generator;

import ca.derekcormier.recipe.cookbook.Cookbook;
import ca.derekcormier.recipe.cookbook.Enum;
import ca.derekcormier.recipe.cookbook.Ingredient;
import ca.derekcormier.recipe.generator.CookbookGenerator;
import ca.derekcormier.recipe.generator.JavaFilters;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import liqp.filters.Filter;

public class JavaIngredientGenerator
extends CookbookGenerator {
    @Override
    public void generate(Cookbook cookbook, String targetDir, Map<String, Object> options) {
        String filepath;
        String rendered;
        HashMap<String, Object> data;
        this.registerFilters(cookbook);
        if (!options.containsKey("javaPackage")) {
            options.put("javaPackage", "");
        }
        options.putIfAbsent("ingredientPostfix", "");
        String javaPackage = (String)options.get("javaPackage");
        if (!javaPackage.isEmpty()) {
            targetDir = targetDir + "/" + String.join((CharSequence)"/", Arrays.asList(javaPackage.split("\\.")));
        }
        String directory = this.createDirectories(targetDir);
        for (Ingredient ingredient : cookbook.getIngredients()) {
            data = new HashMap<String, Object>();
            data.put("ingredient", ingredient);
            data.put("domain", cookbook.getDomain());
            data.put("options", options);
            rendered = this.renderTemplate("templates/java/ingredient.liquid", data);
            filepath = directory + File.separator + ingredient.getName() + options.get("ingredientPostfix") + ".java";
            this.writeToFile(filepath, rendered);
        }
        for (Enum enumeration : cookbook.getEnums()) {
            data = new HashMap();
            data.put("enum", enumeration);
            data.put("options", options);
            rendered = this.renderTemplate("templates/java/enum.liquid", data);
            filepath = directory + File.separator + enumeration.getName() + ".java";
            this.writeToFile(filepath, rendered);
        }
    }

    private void registerFilters(Cookbook cookbook) {
        Filter.registerFilter((Filter)JavaFilters.createJavaTypeFilter(cookbook));
        Filter.registerFilter((Filter)JavaFilters.createJavaValueFilter(cookbook));
    }
}

