/*
 * Decompiled with CFR 0.152.
 */
package ca.derekcormier.recipe.generator;

import ca.derekcormier.recipe.generator.Main;
import java.util.ArrayList;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="generate", defaultPhase=LifecyclePhase.GENERATE_SOURCES)
public class RecipeGeneratorMojo
extends AbstractMojo {
    @Component
    private MojoExecution execution;
    @Component
    private MavenProject project;
    @Parameter
    private String flavour;
    @Parameter(defaultValue="${project.basedir}/cookbook.yaml")
    private String cookbook;
    @Parameter(defaultValue="${project.build.directory}/generated-sources/recipe")
    private String targetDir;
    @Parameter
    private String javaPackage;
    @Parameter
    private String ingredientPostfix;

    public void execute() throws MojoExecutionException, MojoFailureException {
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.flavour);
        args.add(this.cookbook);
        args.add(this.targetDir);
        if (null != this.javaPackage) {
            args.add("--javaPackage");
            args.add(this.javaPackage);
        }
        if (null != this.ingredientPostfix) {
            args.add("--ingredientPostfix");
            args.add(this.ingredientPostfix);
        }
        Main.main((String[])args.toArray(new String[args.size()]));
        if (this.flavour.startsWith("java-")) {
            if (this.execution.getLifecyclePhase().equals("generate-sources")) {
                this.project.addCompileSourceRoot(this.targetDir);
            } else if (this.execution.getLifecyclePhase().equals("generate-test-sources")) {
                this.project.addTestCompileSourceRoot(this.targetDir);
            }
        }
    }
}

