@file:Suppress("unused")

package ca.deprecatedlogic.jsoup.dsl

import ca.deprecatedlogic.jsoup.nodes.attributes
import ca.deprecatedlogic.jsoup.nodes.body
import ca.deprecatedlogic.jsoup.nodes.classNames
import ca.deprecatedlogic.jsoup.nodes.head
import ca.deprecatedlogic.jsoup.nodes.owner
import org.jsoup.nodes.Element

class ElementConsumer(val root: Element) {
    //region Operators
    operator fun invoke(command: ElementConsumer.() -> Unit): ElementConsumer {
        command(this)
        return this
    }

    operator fun String.unaryPlus() {
        root.append(this)
    }
    //endregion

    //region DSL Methods
    fun element(tag: String): ElementConsumer
        = ElementConsumer(root.appendElement(tag))

    fun element(tag: String, command: ElementConsumer.() -> Unit): ElementConsumer
        = ElementConsumer(root.appendElement(tag))(command)

    fun head(): ElementConsumer {
        val owner = root.owner ?: throw UnsupportedOperationException("There is no owner document for this node.")
        return ElementConsumer(owner.head)
    }

    fun head(command: ElementConsumer.() -> Unit): ElementConsumer {
        val owner = root.owner ?: throw UnsupportedOperationException("There is no owner document for this node.")
        return ElementConsumer(owner.head)(command)
    }

    fun body(): ElementConsumer {
        val owner = root.owner ?: throw UnsupportedOperationException("There is no owner document for this node.")
        return ElementConsumer(owner.body)
    }

    fun body(command: ElementConsumer.() -> Unit): ElementConsumer {
        val owner = root.owner ?: throw UnsupportedOperationException("There is no owner document for this node.")
        return ElementConsumer(owner.body)(command)
    }

    fun classes(): ClassConsumer {
        val consumer = ClassConsumer()
        root.classNames = consumer.classes
        return consumer
    }

    fun classes(command: ClassConsumer.() -> Unit): ClassConsumer {
        val consumer = ClassConsumer()
        root.classNames = consumer(command).classes
        return consumer
    }

    fun attributes(): AttributeConsumer
        = AttributeConsumer(root.attributes)

    fun attributes(command: AttributeConsumer.() -> Unit): AttributeConsumer
        = AttributeConsumer(root.attributes)(command)
    //endregion
}
