package ca.deprecatedlogic.jsoup.dsl

import org.jsoup.nodes.Document
import org.jsoup.nodes.Element

fun Element.appendHTML(): ElementConsumer
    = ElementConsumer(this)

fun Element.appendHTML(command: ElementConsumer.() -> Unit): ElementConsumer
    = ElementConsumer(this)(command)

fun Appendable.appendHTML(): ElementConsumer {
    val document = Document.createShell("")
    val consumer = ElementConsumer(document)
    val output = document.toString()
    append(output)
    return consumer
}

fun Appendable.appendHTML(command: ElementConsumer.() -> Unit): ElementConsumer {
    val document = Document.createShell("")
    val consumer = ElementConsumer(document)(command)
    val output = document.toString()
    append(output)
    return consumer
}
