package ca.deprecatedlogic.jsoup.dsl

class ClassConsumer {
    val classes: MutableSet<String> = LinkedHashSet()

    operator fun invoke(command: ClassConsumer.() -> Unit): ClassConsumer {
        command(this)
        return this
    }

    operator fun String.unaryPlus() {
        classes += this
    }

    operator fun String.unaryMinus() {
        classes -= this
    }
}
