package ca.deprecatedlogic.jsoup.dsl

import ca.deprecatedlogic.jsoup.nodes.set
import org.jsoup.nodes.Attributes

class AttributeConsumer(val attributes: Attributes) {
    //region Operators
    operator fun invoke(command: AttributeConsumer.() -> Unit): AttributeConsumer {
        command(this)
        return this
    }

    operator fun String.unaryMinus() {
        if (attributes.hasKey(this)) {
            attributes.remove(this)
        }
    }
    //endregion

    //region Infix Methods
    infix fun String.add(value: String) {
        if (attributes.hasKey(this)) {
            return

        }
        else {
            attributes[this] = value
        }
    }

    infix fun String.set(value: String) {
        attributes.put(this, value)
    }
    //endregion
}
