package ca.deprecatedlogic.jsoup.dsl

import ca.deprecatedlogic.jsoup.nodes.attributes
import ca.deprecatedlogic.jsoup.nodes.classNames
import org.jsoup.nodes.Element

class ElementConsumer(val root: Element) {
    //region Operator Methods
    operator fun invoke(command: ElementConsumer.() -> Unit): ElementConsumer {
        command(this)
        return this
    }

    operator fun String.unaryPlus() {
        root.appendText(this)
    }
    //endregion

    //region DSL Methods
    fun element(tag: String): ElementConsumer
        = ElementConsumer(root.appendElement(tag))

    fun element(tag: String, command: ElementConsumer.() -> Unit): ElementConsumer
        = ElementConsumer(root.appendElement(tag))(command)

    fun classes(): ClassConsumer {
        val consumer = ClassConsumer()
        root.classNames = consumer.classes
        return consumer
    }

    fun classes(command: ClassConsumer.() -> Unit): ClassConsumer {
        val consumer = ClassConsumer()
        root.classNames = consumer(command).classes
        return consumer
    }

    fun attributes(): AttributeConsumer
        = AttributeConsumer(root.attributes)

    fun attributes(command: AttributeConsumer.() -> Unit): AttributeConsumer
        = AttributeConsumer(root.attributes)(command)
    //endregion
}
