@file:Suppress("unused")

package ca.deprecatedlogic.jsoup

import org.jsoup.nodes.Attributes

//region Read-Only Extension Properties
val Attributes.size: Int
    get() = size()
//endregion

//region Extension Methods
operator fun Attributes.set(key: String, value: String) = put(key, value)
operator fun Attributes.set(key: String, value: Boolean) = put(key, value)
operator fun Attributes.contains(key: String): Boolean = hasKey(key)
operator fun Attributes.plusAssign(attributes: Attributes) = addAll(attributes)
//endregion
