@file:Suppress("unused")

package ca.deprecatedlogic.jsoup

import org.jsoup.nodes.Document
import org.jsoup.nodes.Element

//region Read-Only Extension Properties
val Document.head: Element
    get() = head()

val Document.body: Element
    get() = body()

val Document.location: String
    get() = location()
//endregion

//region Mutable Extension Properties
var Document.title: String?
    get() = title().takeUnless { it.isEmpty() }
    set(value) {
        title(value)
    }
//endregion

//region Extension Methods
fun Document.toByteArray(): ByteArray = toString().toByteArray(charset())
//endregion
