@file:Suppress("unused")

package ca.deprecatedlogic.jsoup

import org.jsoup.nodes.Attributes
import org.jsoup.nodes.DataNode
import org.jsoup.nodes.Element
import org.jsoup.nodes.Node
import org.jsoup.select.Elements

//region Read-Only Extension Properties
val Element.attributes: Attributes
    get() = attributes()

val Element.hyperlink: String?
    get() = attr("href").takeUnless { it.isEmpty() }

val Element.id: String?
    get() = id().takeUnless { it.isEmpty() }

val Element.data: String?
    get() = data().takeUnless { it.isEmpty() }

val Element.parent: Element?
    get() = parent()

val Element.parents: Elements
    get() = parents()

val Element.dataset: Map<String, String>
    get() = dataset()

val Element.dataNodes: List<DataNode>
    get() = dataNodes()

val Element.children: Elements
    get() = children()

val Element.ownText: String?
    get() = ownText().takeUnless { it.isEmpty() }
//endregion

//region Mutable Extension Properties
var Element.html: String
    get() = html()
    set(value) {
        html(value)
    }

var Element.text: String
    get() = text()
    set(value) {
        text(value)
    }

var Element.tagName: String
    get() = tagName()
    set(value) {
        tagName(value)
    }

var Element.classNames: Set<String>
    get() = classNames()
    set(value) {
        classNames(value)
    }

var Element.value: String?
    get() = `val`().takeUnless { it.isEmpty() }
    set(value) {
        if (value == null) `val`("") else `val`(value)
    }
//endregion

//region Extension Functions
operator fun Element.plus(node: Node): Element = appendChild(node)

operator fun Element.get(index: Int): Element = child(index)
//endregion
