package ca.deprecatedlogic.debate.option

/**
 * A program argument that has at least one parameter.
 */
abstract class ParameterOption<T : Any> : BaseOption() {
    /**
     * Determines whether or not a program argument is mandatory.
     */
    var required: Boolean = false

    /**
     * An optional default value for the program argument, which will be used if
     * no value is supplied by the user.
     */
    var default: T? = null

    /**
     * Indicates that a program argument must be present.
     */
    fun required(): BaseOption {
        this.required = true
        return this
    }

    /**
     * Sets an optional default value that is used if no value is present in program arguments.
     */
    fun default(default: T): BaseOption {
        this.default = default
        return this
    }
}
