package ca.deprecatedlogic.debate.option

/**
 * The base class for all option implementations.
 */
abstract class BaseOption(override var name: String? = null) : Option {
    override var short: Char? = null
    override var help: String? = null

    /**
     * Sets the name of your option to a manually-supplied value.
     */
    fun name(name: String): BaseOption {
        this.name = name
        return this
    }
    
    /**
     * Sets a short-form character for your option.
     */
    fun short(flag: Char): BaseOption {
        this.short = flag
        return this
    }

    /**
     * Sets a help message containing a description of the intended usage and effects of the option.
     */
    fun help(help: String): BaseOption {
        this.help = help
        return this
    }
}

