package ca.deprecatedlogic.debate.option

/**
 * Contains configuration information for an expected program argument.
 */
interface Option {
    /**
     * The full name of the program argument (eg: '--verbose').
     */
    val name: String

    /**
     * An optional short-form of the program argument (eg: '-v').
     */
    var short: Char?

    /**
     * An optional description of the program argument, containing information
     * such as describing the effect and purpose of the argument.
     */
    var help: String?
}
