package ca.deprecatedlogic.debate.parsing

import ca.deprecatedlogic.debate.option.DoubleOption
import ca.deprecatedlogic.debate.option.FlagOption
import ca.deprecatedlogic.debate.option.FloatOption
import ca.deprecatedlogic.debate.option.IntegerOption
import ca.deprecatedlogic.debate.option.LongOption
import ca.deprecatedlogic.debate.option.PositionalOption
import ca.deprecatedlogic.debate.option.StringOption

/**
 * An implementing object or class serves as a declaration of how your
 * program arguments are to be interpreted.
 *
 * Note that the ordering of member properties must match the expected ordering of
 * program arguments.
 */
abstract class Options {
    /**
     * Expects a new flag program argument.
     */
    fun flag(name: String) = FlagOption(name)

    /**
     * Expects a new positional program argument.
     */
    fun positional(name: String) = PositionalOption(name)

    /**
     * Expects a new [Int] program argument.
     */
    fun integer(name: String) = IntegerOption(name)

    /**
     * Expects a new [Long] program argument.
     */
    fun long(name: String) = LongOption(name)

    /**
     * Expects a new [Float] program argument.
     */
    fun float(name: String) = FloatOption(name)

    /**
     * Expects a new [Double] program argument.
     */
    fun double(name: String) = DoubleOption(name)

    /**
     * Expects a new [String] program argument.
     */
    fun string(name: String) = StringOption(name)
}
