package ca.deprecatedlogic.debate.option

/**
 * A program argument which has zero or more parameters of any type.
 */
class PositionalOption(name: String) : ParameterOption<List<String>>(name) {
    /**
     * The maximum number of parameters expected.
     */
    var maximum: Int? = null

    /**
     * The minimum number of parameters expected.
     */
    var minimum: Int? = null

    /**
     * Sets the minimum number of expected program argument parameters.
     */
    fun minimum(minimum: Int): PositionalOption {
        this.minimum = minimum
        return this
    }

    /**
     * Sets the maximum number of expected program argument parameters.
     */
    fun maximum(maximum: Int): PositionalOption {
        this.maximum = maximum
        return this
    }
}
