@file:JvmName("Debate")

package ca.deprecatedlogic.debate

import ca.deprecatedlogic.debate.parsing.DefaultParser
import ca.deprecatedlogic.debate.parsing.Options
import ca.deprecatedlogic.debate.parsing.Parser

/**
 * The default program argument parser.
 */
private val default by lazy { DefaultParser() }

/**
 * Uses the default argument parser to parse program arguments.
 *
 * @see Parser.parse
 */
fun parse(arguments: Array<String>, options: Options) = default.parse(arguments, options)

/**
 * Uses the provided [parser] to parse program arguments.
 *
 * @see Parser.parse
 */
@Suppress("unused")
fun parse(arguments: Array<String>, options: Options, parser: Parser) = parser.parse(arguments, options)
