package ca.deprecatedlogic.debate.argument

import ca.deprecatedlogic.debate.exception.ParsingError
import ca.deprecatedlogic.debate.option.Option
import kotlin.reflect.KProperty

/**
 * A collection of program arguments.
 */
class Parsed(delegate: List<Token>) : List<Token> by delegate {
    /**
     * Returns *true* if the referenced flag is present, *false* if it is not,
     * or *null* if no argument matching the [property] was found.
     */
    fun flag(property: KProperty<*>): Boolean? = argument(property)

    fun integers(property: KProperty<*>): List<Int>? = arguments(property)

    fun longs(property: KProperty<*>): List<Long>? = arguments(property)

    fun floats(property: KProperty<*>): List<Float>? = arguments(property)

    fun doubles(property: KProperty<*>): List<Double>? = arguments(property)

    fun strings(property: KProperty<*>): List<String>? = arguments(property)

    private fun argument(property: KProperty<*>): Boolean? {
        val option = property.call() as? Option<*> ?: throw ParsingError()
        val match = singleOrNull { it.name == option.name } ?: return null

        val flag = match as? Argument ?: return null

        return flag.value
    }

    private inline fun <reified T> arguments(property: KProperty<*>): List<T>? {
        val option = property.call() as? Option<*> ?: throw ParsingError()
        val match = singleOrNull { it.name == option.name } ?: return null
        val argument = match as? Arguments ?: return null

        return argument.values?.map {
            it as T ?: throw ParsingError()
        }
    }
}
