package ca.deprecatedlogic.debate.option

/**
 * Contains configuration information for an expected program argument.
 */
interface Option<T : Any> {
    /**
     * The full name of the program argument, eg: '--verbose'.
     */
    val name: String

    /**
     * An optional short-form of the program argument, eg: '-v'.
     */
    var flag: Char?

    /**
     * An optional description of the program argument, containing information
     * such as describing the effect and purpose of the argument.
     */
    var help: String?

    /**
     * A list of optional default values for the program argument, which will be used if
     * no value is supplied by the user.
     */
    var defaults: List<T>?

    /**
     * Determines whether or not a program argument is mandatory.
     */
    var required: Boolean
}
