package ca.deprecatedlogic.debate.argument

import ca.deprecatedlogic.debate.exception.ParsingError
import ca.deprecatedlogic.debate.option.Option
import kotlin.reflect.KProperty

/**
 * A collection of program arguments.
 */
class Parsed(delegate: List<Token>) : List<Token> by delegate {
    constructor(vararg arguments: Argument) : this(arguments.toList())

    /**
     * Extracts a [Boolean] value corresponding to the given [Option] member [property].
     */
    fun boolean(property: KProperty<*>): Boolean? = flag(property)

    fun integers(property: KProperty<*>): List<Int>? = argument(property)
    fun longs(property: KProperty<*>): List<Long>? = argument(property)
    fun floats(property: KProperty<*>): List<Float>? = argument(property)
    fun doubles(property: KProperty<*>): List<Double>? = argument(property)
    fun strings(property: KProperty<*>): List<String>? = argument(property)

    private fun flag(property: KProperty<*>): Boolean? {
        val option = property.call() as? Option<*> ?: throw ParsingError()
        val match = singleOrNull { it.name == option.name } ?: return null

        val flag = match as? Argument ?: return null

        return flag.value
    }

    private inline fun <reified T> argument(property: KProperty<*>): List<T>? {
        val option = property.call() as? Option<*> ?: throw ParsingError()
        val match = singleOrNull { it.name == option.name } ?: return null
        val argument = match as? Arguments ?: return null

        return argument.values?.map {
            it as T ?: throw ParsingError()
        }
    }
}
